/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.opds;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.luwrain.core.NullCheck;

final class Opds {
    private static final int BUFFER_SIZE = 32768;

    Opds() {
    }

    static Result fetch(URL url) {
        Document doc;
        NullCheck.notNull((Object)url, (String)"url");
        LinkedList<Entry> res = new LinkedList<Entry>();
        try {
            Connection con = Jsoup.connect((String)url.toString());
            con.userAgent("Mozilla/5.0");
            con.timeout(30000);
            doc = con.get();
        }
        catch (IOException e) {
            return new Result(Result.Errors.FETCHING_PROBLEM);
        }
        for (Element node : doc.getElementsByTag("entry")) {
            try {
                Entry entry = Opds.parseEntry(url, node);
                res.add(entry);
            }
            catch (Exception exception) {}
        }
        return new Result(res.toArray(new Entry[res.size()]));
    }

    private static Entry parseEntry(URL parentUrl, Element el) throws Exception {
        NullCheck.notNull((Object)el, (String)"el");
        String id = "";
        String title = "";
        LinkedList<Link> links = new LinkedList<Link>();
        LinkedList<Author> authors = new LinkedList<Author>();
        for (Element node : el.getElementsByTag("title")) {
            title = node.text();
        }
        for (Element node : el.getElementsByTag("id")) {
            id = node.text();
        }
        for (Element node : el.getElementsByTag("link")) {
            links.add(new Link(node.attributes().get("href"), node.attributes().get("rel"), node.attributes().get("type"), node.attributes().get("profile")));
        }
        for (Element node : el.getElementsByTag("author")) {
            String name = null;
            for (Element nameNode : el.getElementsByTag("name")) {
                name = nameNode.text();
            }
            if (name == null) continue;
            authors.add(new Author(name));
        }
        if (id == null) {
            id = "---";
        }
        if (title == null) {
            title = "---";
        }
        return new Entry(id, parentUrl, title, links.toArray(new Link[links.size()]), authors.toArray(new Author[authors.size()]));
    }

    static final class Result {
        private final Entry[] entries;
        final Errors error;

        Result(Errors error) {
            NullCheck.notNull((Object)((Object)error), (String)"error");
            this.error = error;
            this.entries = null;
        }

        Result(Entry[] entries) {
            NullCheck.notNullItems((Object[])entries, (String)"entries");
            this.error = Errors.OK;
            this.entries = entries;
        }

        Entry[] getEntries() {
            return (Entry[])this.entries.clone();
        }

        boolean hasEntries() {
            return this.error == Errors.OK && this.entries != null;
        }

        static enum Errors {
            FETCHING_PROBLEM,
            OK;

        }
    }

    static final class Entry {
        final String id;
        final URL parentUrl;
        final String title;
        final Link[] links;
        final Author[] authors;

        Entry(String id, URL parentUrl, String title, Link[] links, Author[] authors) {
            NullCheck.notNull((Object)id, (String)"id");
            NullCheck.notNull((Object)parentUrl, (String)"parentUrl");
            NullCheck.notNull((Object)title, (String)"title");
            NullCheck.notNullItems((Object[])links, (String)"links");
            NullCheck.notNullItems((Object[])authors, (String)"authors");
            this.id = id;
            this.parentUrl = parentUrl;
            this.title = title;
            this.links = links != null ? links : new Link[]{};
            this.authors = authors;
        }

        public String toString() {
            return this.title;
        }
    }

    static final class Link {
        final String url;
        final String rel;
        final String type;
        final String profile;

        Link(String url, String rel, String type, String profile) {
            NullCheck.notNull((Object)url, (String)"url");
            this.url = url;
            this.rel = rel;
            this.type = type;
            this.profile = profile;
        }

        public String toString() {
            return "url=" + this.url + ",rel=" + this.rel + ",type=" + this.type;
        }
    }

    static final class Author {
        final String name;

        Author(String name) {
            NullCheck.notNull((Object)name, (String)"name");
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

