/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_term;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.linux_term.App;
import org.luwrain.app.linux_term.Strings;
import org.luwrain.app.linux_term.Terminal;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class MainLayout
extends LayoutBase {
    private final App app;
    private final Terminal term;
    private final NavigationArea termArea;
    private List<String> lines = new ArrayList<String>();
    private int oldHotPointX = -1;
    private int oldHotPointY = -1;

    MainLayout(final App app) {
        this.app = app;
        this.term = new Terminal(app.getLuwrain(), app.termInfo);
        this.termArea = new NavigationArea((ControlContext)new DefaultControlContext(app.getLuwrain())){

            public boolean onInputEvent(InputEvent event) {
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case ENTER: {
                            app.sendChar('\n');
                            return true;
                        }
                        case TAB: {
                            app.sendChar('\t');
                            return true;
                        }
                        case BACKSPACE: {
                            app.sendChar('\b');
                            return true;
                        }
                        case ESCAPE: {
                            app.closeApp();
                            return true;
                        }
                        case ALTERNATIVE_ARROW_UP: {
                            app.sendChar('\u001b');
                            app.sendChar('[');
                            app.sendChar('A');
                            return true;
                        }
                        case ALTERNATIVE_ARROW_LEFT: {
                            app.sendChar('\u001b');
                            app.sendChar('[');
                            app.sendChar('D');
                            return true;
                        }
                    }
                }
                if (!event.isSpecial() && event.withControlOnly()) {
                    switch (event.getChar()) {
                        case 'd': {
                            app.sendChar('\u0004');
                            return true;
                        }
                    }
                }
                if (!(event.isSpecial() || event.isModified() && !event.withShiftOnly())) {
                    app.sendChar(event.getChar());
                    return true;
                }
                if (app.onInputEvent((Area)this, event)) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case CLOSE: {
                            app.closeApp();
                            return true;
                        }
                    }
                }
                if (app.onSystemEvent((Area)this, event)) {
                    return true;
                }
                return super.onSystemEvent(event);
            }

            public int getLineCount() {
                int count = MainLayout.this.term.getLineCount();
                return count > 0 ? count : 1;
            }

            public String getLine(int index) {
                return MainLayout.this.term.getLine(index);
            }

            public void announceLine(int index, String line) {
                1.defaultLineAnnouncement((ControlContext)this.context, (int)index, (String)app.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING));
            }

            public String getAreaName() {
                return ((Strings)app.getStrings()).areaName();
            }
        };
    }

    void update(char ch) {
    }

    void termText(String text) {
        this.term.termText(text.replaceAll("\u001b\\[\\?2004[hl]", ""));
        this.termArea.setHotPoint(this.term.getHotPointX(), this.term.getHotPointY());
    }

    AreaLayout getLayout() {
        return new AreaLayout((Area)this.termArea);
    }
}

