/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.interaction.javafx;

import javafx.application.Application;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.graphical.FxThread;
import org.luwrain.graphical.ResizableCanvas;
import org.luwrain.interaction.javafx.OnScreenLine;
import org.luwrain.interaction.javafx.OnScreenLineTracker;
import org.luwrain.interaction.javafx.ThreadControl;

public final class App
extends Application {
    private static final String LOG_COMPONENT = "fx";
    private static final int MIN_TABLE_WIDTH = 16;
    private static final int MIN_TABLE_HEIGHT = 8;
    private StackPane rootPane = null;
    private Stage stage = null;
    private ResizableCanvas textCanvas = null;
    private GraphicsContext gc = null;
    private Bounds charBounds = null;
    private Font font = null;
    private Font font2 = null;
    private Color fontColor = Color.GREY;
    private Color font2Color = Color.WHITE;
    private Color bkgColor = Color.BLACK;
    private Color bkgColor2 = Color.BLACK;
    private Color splitterColor = Color.GRAY;
    private double canvasWidth;
    private double canvasHeight;
    private int hotPointX = -1;
    private int hotPointY = -1;
    private int marginLeft = 0;
    private int marginTop = 0;
    private int marginRight = 0;
    private int marginBottom = 0;
    private int tableWidth = 0;
    private int tableHeight = 0;
    private char[][] table;
    private boolean[][] tableFont2;
    private OnScreenLineTracker[] vertLines;
    private OnScreenLineTracker[] horizLines;

    public void start(Stage stage) throws Exception {
        NullCheck.notNull((Object)stage, (String)"stage");
        this.stage = stage;
        stage.setResizable(true);
        stage.setTitle("LUWRAIN");
        this.rootPane = new StackPane();
        this.rootPane.resize(1024.0, 768.0);
        this.textCanvas = new ResizableCanvas();
        this.rootPane.getChildren().add((Object)this.textCanvas);
        stage.setScene(new Scene((Parent)this.rootPane));
        this.textCanvas.bindWidthAndHeight(this.rootPane);
        this.gc = this.textCanvas.getGraphicsContext2D();
        this.rootPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        ThreadControl.appStarted(this);
    }

    void setInteractionFont(Font font, Font font2) {
        NullCheck.notNull((Object)font, (String)"font");
        NullCheck.notNull((Object)font2, (String)"font2");
        this.font = font;
        this.font2 = font2;
        Text text = new Text("A");
        text.setFont(font);
        this.charBounds = text.getLayoutBounds();
    }

    synchronized boolean initTable() {
        int i;
        FxThread.ensure();
        double width = this.canvasWidth;
        double height = this.canvasHeight;
        if (width < (double)(this.marginLeft + this.marginRight)) {
            Log.error((String)LOG_COMPONENT, (String)("table initialization failure: left + right margins are greater than window width (" + this.marginLeft + "+" + this.marginRight + "<" + width + ")"));
            return false;
        }
        if (height < (double)(this.marginTop + this.marginBottom)) {
            Log.error((String)LOG_COMPONENT, (String)("table initialization failure: top + bottom margins are greater than window height (" + this.marginTop + "+" + this.marginBottom + "<" + height + ")"));
            return false;
        }
        int width_ = (int)Math.floor((width -= (double)(this.marginLeft + this.marginRight)) / this.charBounds.getWidth());
        int height_ = (int)Math.floor((height -= (double)(this.marginTop + this.marginBottom)) / this.charBounds.getHeight());
        if (width_ < 16 || height_ < 8) {
            Log.error((String)LOG_COMPONENT, (String)("too small table for initialization:" + width_ + "x" + height_));
            return false;
        }
        this.tableWidth = width_;
        this.tableHeight = height_;
        this.table = new char[this.tableWidth][];
        this.tableFont2 = new boolean[this.tableWidth][];
        for (i = 0; i < this.tableWidth; ++i) {
            this.table[i] = new char[this.tableHeight];
            this.tableFont2[i] = new boolean[this.tableHeight];
        }
        for (i = 0; i < this.tableWidth; ++i) {
            for (int j = 0; j < this.tableHeight; ++j) {
                this.table[i][j] = 32;
                this.tableFont2[i][j] = false;
            }
        }
        this.vertLines = new OnScreenLineTracker[this.tableWidth];
        for (i = 0; i < this.tableWidth; ++i) {
            this.vertLines[i] = new OnScreenLineTracker();
        }
        this.horizLines = new OnScreenLineTracker[this.tableHeight];
        for (i = 0; i < this.tableHeight; ++i) {
            this.horizLines[i] = new OnScreenLineTracker();
        }
        return true;
    }

    void setColors(Color fontColor, Color font2color, Color bkgColor, Color splitterColor) {
        NullCheck.notNull((Object)fontColor, (String)"fontColor");
        NullCheck.notNull((Object)this.font2Color, (String)"font2Color");
        NullCheck.notNull((Object)bkgColor, (String)"bkgColor");
        NullCheck.notNull((Object)splitterColor, (String)"splitterColor");
        this.fontColor = fontColor;
        this.font2Color = this.font2Color;
        this.bkgColor = bkgColor;
        this.splitterColor = splitterColor;
    }

    void setMargin(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginLeft = marginLeft;
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
    }

    void setSizeAndShow(int width, int height) {
        FxThread.ensure();
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.rootPane.resize((double)width, (double)height);
        this.stage.sizeToScene();
        this.stage.show();
    }

    void setUndecoratedSizeAndShow(double width, double height) {
        FxThread.ensure();
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.rootPane.resize(width, height);
        this.stage.initStyle(StageStyle.UNDECORATED);
        this.stage.setWidth(width);
        this.stage.setHeight(height);
        this.stage.setResizable(false);
        this.stage.show();
    }

    void setHotPoint(int x, int y) {
        if (x < 0 || y < 0) {
            this.hotPointX = -1;
            this.hotPointY = -1;
            return;
        }
        this.hotPointX = x;
        this.hotPointY = y;
    }

    synchronized void putString(int x, int y, String text, boolean withFont2) {
        NullCheck.notNull((Object)text, (String)"text");
        if (this.table == null || x >= this.tableWidth || y >= this.tableHeight || x >= this.table.length || y >= this.table[x].length) {
            return;
        }
        int bound = x + text.length() <= this.tableWidth ? text.length() : this.tableWidth - x;
        for (int i = 0; i < bound; ++i) {
            this.table[x + i][y] = text.charAt(i) != '\u0000' ? (int)text.charAt(i) : 32;
            this.tableFont2[x + i][y] = withFont2;
        }
    }

    synchronized void clearRect(int left, int top, int right, int bottom) {
        int i;
        int b;
        if (this.table == null || this.tableWidth <= 0 || this.tableHeight <= 0) {
            return;
        }
        int l = left >= 0 ? left : 0;
        int t = top >= 0 ? top : 0;
        int r = right < this.tableWidth ? right : this.tableWidth - 1;
        int n = b = bottom < this.tableHeight ? bottom : this.tableHeight - 1;
        if (l > r || t > b) {
            return;
        }
        for (i = l; i <= r; ++i) {
            for (int j = t; j <= b; ++j) {
                this.table[i][j] = 32;
                this.tableFont2[i][j] = false;
            }
        }
        if (this.vertLines != null) {
            for (i = l; i <= r; ++i) {
                this.vertLines[i].uncover(t, b);
            }
        }
        if (this.horizLines != null) {
            for (i = t; i <= b; ++i) {
                this.horizLines[i].uncover(l, r);
            }
        }
    }

    synchronized void paint() {
        int k;
        int j;
        int i;
        FxThread.ensure();
        double fontWidth = this.charBounds.getWidth();
        double fontHeight = this.charBounds.getHeight();
        if (this.table == null) {
            return;
        }
        this.gc.setTextBaseline(VPos.TOP);
        this.gc.setFill((Paint)this.bkgColor);
        this.gc.fillRect(0.0, 0.0, this.stage.getWidth() - 1.0, this.stage.getHeight() - 1.0);
        this.gc.setFont(this.font);
        this.gc.setFill((Paint)this.fontColor);
        char[] chars = new char[this.tableWidth];
        for (i = 0; i < this.tableHeight; ++i) {
            for (j = 0; j < this.tableWidth; ++j) {
                chars[j] = this.tableFont2[j][i] ? 32 : this.table[j][i];
            }
            this.gc.fillText(new String(chars), (double)this.marginLeft, (double)i * fontHeight + (double)this.marginTop);
        }
        this.gc.setFont(this.font2);
        this.gc.setFill((Paint)this.font2Color);
        for (i = 0; i < this.tableHeight; ++i) {
            for (j = 0; j < this.tableWidth; ++j) {
                if (!this.tableFont2[j][i]) continue;
                this.gc.fillText("" + this.table[j][i], (double)this.marginLeft + (double)j * fontWidth, (double)i * fontHeight + (double)this.marginTop);
            }
        }
        this.gc.setFill((Paint)this.splitterColor);
        if (this.vertLines != null) {
            for (i = 0; i < this.vertLines.length; ++i) {
                if (this.vertLines[i] == null) continue;
                OnScreenLine[] lines = this.vertLines[i].getLines();
                for (k = 0; k < lines.length; ++k) {
                    this.gc.fillRect((double)this.marginLeft + (double)i * fontWidth + fontWidth / 2.0 - fontWidth / 6.0, (double)this.marginTop + (double)lines[k].pos1 * fontHeight, fontWidth / 3.0, (double)(lines[k].pos2 - lines[k].pos1 + 1) * fontHeight);
                }
            }
        }
        if (this.horizLines != null) {
            for (i = 0; i < this.horizLines.length; ++i) {
                if (this.horizLines[i] == null) continue;
                OnScreenLine[] lines = this.horizLines[i].getLines();
                for (k = 0; k < lines.length; ++k) {
                    this.gc.fillRect((double)this.marginLeft + (double)lines[k].pos1 * fontWidth, (double)this.marginTop + (double)i * fontHeight + fontHeight / 2.0 - fontWidth / 6.0, (double)(lines[k].pos2 - lines[k].pos1 + 1) * fontWidth, fontWidth / 3.0);
                }
            }
        }
        if (this.hotPointX >= 0 && this.hotPointY >= 0 && this.hotPointX < this.tableWidth && this.hotPointY < this.tableHeight) {
            this.gc.setFill((Paint)this.fontColor);
            this.gc.fillRect((double)this.hotPointX * fontWidth + (double)this.marginLeft, (double)this.hotPointY * fontHeight + (double)this.marginTop, fontWidth, fontHeight);
            this.gc.setFill((Paint)this.bkgColor);
            Object str = new String();
            str = (String)str + this.table[this.hotPointX][this.hotPointY];
            this.gc.fillText((String)str, (double)this.hotPointX * fontWidth + (double)this.marginLeft, (double)this.hotPointY * fontHeight + (double)this.marginTop);
        }
    }

    synchronized void drawVerticalLine(int top, int bottom, int x) {
        if (this.vertLines == null) {
            return;
        }
        if (x >= this.vertLines.length) {
            Log.warning((String)LOG_COMPONENT, (String)("unable to draw vertical line at column " + x + ", max vertical line is allowed at " + (this.vertLines.length - 1)));
            return;
        }
        if (this.vertLines[x] != null) {
            this.vertLines[x].cover(top, bottom);
        }
    }

    synchronized void drawHorizontalLine(int left, int right, int y) {
        if (this.horizLines == null) {
            return;
        }
        if (y >= this.horizLines.length) {
            Log.warning((String)LOG_COMPONENT, (String)("unable to draw horizontal line at row " + y + ", max horizontal line is allowed at " + (this.horizLines.length - 1)));
            return;
        }
        if (this.horizLines[y] != null) {
            this.horizLines[y].cover(left, right);
        }
    }

    void putNew(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.rootPane.getChildren().add((Object)node);
        if (node instanceof ResizableCanvas) {
            ((ResizableCanvas)node).bindWidthAndHeight(this.rootPane);
        }
        node.requestFocus();
    }

    void remove(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.rootPane.getChildren().remove((Object)node);
    }

    Font getInteractionFont() {
        return this.font;
    }

    Font getInteractionFont2() {
        return this.font;
    }

    int getTableWidth() {
        return this.tableWidth;
    }

    int getTableHeight() {
        return this.tableHeight;
    }

    Stage getStage() {
        return this.stage;
    }
}

