/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.calc;

import java.util.function.Function;
import org.graalvm.polyglot.Value;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.calc.MainLayout;
import org.luwrain.app.calc.Strings;
import org.luwrain.core.AreaLayout;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.core.Module;

public final class App
extends AppBase<Strings> {
    static final String LOG_COMPONENT = "calc";
    private Module module = null;
    private MainLayout mainLayout = null;

    public App() {
        super("luwrain.calc", Strings.class, "luwrain.calc");
    }

    @Override
    public AreaLayout onAppInit() {
        this.module = new Module(this.getLuwrain(), (bindings, syncObj) -> {
            bindings.putMember("pi", (Object)Math.PI);
            bindings.putMember("abs", args -> App.singleArg(args, x -> Math.abs(x)));
            bindings.putMember("sqrt", args -> App.singleArg(args, x -> Math.sqrt(x)));
            bindings.putMember("exp", args -> App.singleArg(args, x -> Math.exp(x)));
            bindings.putMember("log", args -> App.singleArg(args, x -> Math.log(x)));
            bindings.putMember("log10", args -> App.singleArg(args, x -> Math.log10(x)));
            bindings.putMember("floor", args -> App.singleArg(args, x -> Math.floor(x)));
            bindings.putMember("sin", args -> App.singleArg(args, x -> Math.sin(x)));
            bindings.putMember("cos", args -> App.singleArg(args, x -> Math.cos(x)));
            bindings.putMember("tan", args -> App.singleArg(args, x -> Math.tan(x)));
            bindings.putMember("toDegrees", args -> App.singleArg(args, x -> Math.toDegrees(x)));
            bindings.putMember("toRadians", args -> App.singleArg(args, x -> Math.toRadians(x)));
            bindings.putMember("asin", args -> App.singleArg(args, x -> Math.asin(x)));
            bindings.putMember("acos", args -> App.singleArg(args, x -> Math.acos(x)));
            bindings.putMember("atan", args -> App.singleArg(args, x -> Math.atan(x)));
            bindings.putMember("cbrt", args -> App.singleArg(args, x -> Math.cbrt(x)));
            bindings.putMember("sinh", args -> App.singleArg(args, x -> Math.sinh(x)));
            bindings.putMember("cosh", args -> App.singleArg(args, x -> Math.cosh(x)));
        });
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    @Override
    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    Number calculate(String[] expr) throws Exception {
        StringBuilder text = new StringBuilder();
        for (String s : expr) {
            String str = s.replaceAll("//", "#");
            int pos = str.indexOf("#");
            if (pos < 0) {
                text.append(str + " ");
                continue;
            }
            text.append(str.substring(0, pos) + " ");
        }
        return ScriptUtils.asNumber(this.module.eval(new String(text)));
    }

    @Override
    public void closeApp() {
        this.module.close();
        super.closeApp();
    }

    static Double singleArg(Value[] args, Function<Double, Double> f) {
        if (!ScriptUtils.notNullAndLen(args, 1)) {
            throw new IllegalArgumentException("Required one not null arg");
        }
        if (!args[0].isNumber()) {
            throw new IllegalArgumentException("The first argument must be a number");
        }
        return f.apply(args[0].asDouble());
    }
}

