/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.console;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.console.App;
import org.luwrain.app.console.ConsoleCommand;
import org.luwrain.app.console.Utils;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

final class Commands {
    private static final Logger LOG = LogManager.getLogger();

    Commands() {
    }

    static final class Prop
    implements ConsoleCommand {
        private final Luwrain luwrain;

        Prop(Luwrain luwrain) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            this.luwrain = luwrain;
        }

        @Override
        public boolean onCommand(String text, App app) {
            if (!Utils.firstWord(text).equals("prop")) {
                return false;
            }
            int pos = text.indexOf(" ");
            if (pos < 0) {
                LOG.trace("prop: no argument");
                return true;
            }
            String arg = text.substring(pos).trim();
            if (arg.isEmpty()) {
                LOG.trace("prop: no argument");
                return true;
            }
            File fileValue = this.luwrain.getFileProperty(arg);
            if (fileValue != null) {
                LOG.trace("file: " + fileValue.toString() + " (" + fileValue.getAbsolutePath() + ")");
                return true;
            }
            String value = this.luwrain.getProperty(arg);
            if (!value.isEmpty()) {
                LOG.trace(value);
            } else {
                LOG.trace("empty");
            }
            return true;
        }
    }
}

