/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.cpanel;

import org.luwrain.app.cpanel.ControlPanelApp;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;

class ControlPanelImpl
implements ControlPanel {
    private Luwrain luwrain;
    private ControlPanelApp app;

    ControlPanelImpl(Luwrain luwrain, ControlPanelApp app) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)app, (String)"app");
        this.luwrain = luwrain;
        this.app = app;
    }

    @Override
    public void close() {
        this.app.closeApp();
    }

    @Override
    public void gotoSectionsTree() {
        this.app.gotoSections();
    }

    @Override
    public void refreshSectionsTree() {
        this.app.refreshSectionsTree();
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ESCAPE: {
                    this.close();
                    return true;
                }
                case TAB: {
                    this.gotoSectionsTree();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case CLOSE: {
                this.close();
                return true;
            }
        }
        return false;
    }

    @Override
    public Luwrain getCoreInterface() {
        return this.luwrain;
    }
}

