/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.Comparator;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;

public class CommanderUtils {
    public static void defaultEntryAnnouncement(ControlContext context, String name, CommanderArea.EntryType type, boolean marked) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        if (name.trim().isEmpty() && type != CommanderArea.EntryType.PARENT) {
            context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append(context.getSpeakableText(name, Luwrain.SpeakableTextType.PROGRAMMING));
        switch (type) {
            case PARENT: {
                context.say(context.getStaticStr("CommanderParentDirectory"));
                return;
            }
            case DIR: {
                b.append(context.getStaticStr("CommanderDirectory"));
                break;
            }
            case SYMLINK: 
            case SYMLINK_DIR: {
                b.append(context.getStaticStr("CommanderSymlink"));
                break;
            }
            case SPECIAL: {
                b.append(context.getStaticStr("CommanderSpecial"));
            }
        }
        context.setEventResponse(DefaultEventResponse.text(marked ? Sounds.SELECTED : Sounds.LIST_ITEM, new String(b)));
    }

    public static class AllEntriesFilter<E>
    implements CommanderArea.Filter<E> {
        @Override
        public boolean commanderEntrySuits(E entry) {
            return true;
        }
    }

    public static class ByNameComparator<E>
    implements Comparator<E> {
        @Override
        public int compare(E o1, E o2) {
            NullCheck.notNull(o1, (String)"o1");
            NullCheck.notNull(o2, (String)"o2");
            if (!(o1 instanceof CommanderArea.NativeItem) || !(o2 instanceof CommanderArea.NativeItem)) {
                return 0;
            }
            CommanderArea.NativeItem w1 = (CommanderArea.NativeItem)o1;
            CommanderArea.NativeItem w2 = (CommanderArea.NativeItem)o2;
            if (w1.getEntryType() == CommanderArea.EntryType.PARENT) {
                return w2.getEntryType() == CommanderArea.EntryType.PARENT ? 0 : -1;
            }
            if (w2.getEntryType() == CommanderArea.EntryType.PARENT) {
                return w1.getEntryType() == CommanderArea.EntryType.PARENT ? 0 : 1;
            }
            String name1 = w1.getBaseName().toLowerCase();
            String name2 = w2.getBaseName().toLowerCase();
            if (w1.isDirectory() && w2.isDirectory()) {
                return name1.compareTo(name2);
            }
            if (w1.isDirectory()) {
                return -1;
            }
            if (w2.isDirectory()) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

