/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.concurrent.FutureTask;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.Area;
import org.luwrain.core.Clipboard;
import org.luwrain.core.EventResponse;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.UniRefInfo;
import org.luwrain.i18n.I18n;
import org.luwrain.i18n.LangStatic;

public class DefaultControlContext
implements ControlContext {
    protected final Luwrain luwrain;

    public DefaultControlContext(Luwrain luwrain) {
        this.luwrain = luwrain;
    }

    @Override
    public void say(String text) {
        this.luwrain.speak(text);
    }

    @Override
    public void say(String text, Sounds sound) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)sound), (String)"sound");
        this.luwrain.speak(text, sound);
    }

    @Override
    public void sayStaticStr(LangStatic id) {
        NullCheck.notNull((Object)((Object)id), (String)"id");
        this.say(this.staticStr(id));
    }

    @Override
    public void sayLetter(char letter) {
        this.luwrain.speakLetter(letter);
    }

    @Override
    public void onAreaNewName(Area area) {
        this.luwrain.onAreaNewName(area);
    }

    @Override
    public void onAreaNewContent(Area area) {
        this.luwrain.onAreaNewContent(area);
    }

    @Override
    public void onAreaNewHotPoint(Area area) {
        this.luwrain.onAreaNewHotPoint(area);
    }

    @Override
    public int getAreaVisibleWidth(Area area) {
        return this.luwrain.getAreaVisibleWidth(area);
    }

    @Override
    public int getAreaVisibleHeight(Area area) {
        return this.luwrain.getAreaVisibleHeight(area);
    }

    @Override
    public void popup(Popup popupObj) {
        this.luwrain.popup(popupObj);
    }

    @Override
    public String staticStr(LangStatic id) {
        NullCheck.notNull((Object)((Object)id), (String)"id");
        return this.luwrain.i18n().staticStr(id);
    }

    @Override
    public String getStaticStr(String id) {
        NullCheck.notNull((Object)id, (String)"id");
        return this.luwrain.i18n().getStaticStr(id);
    }

    @Override
    public void playSound(Sounds sound) {
        NullCheck.notNull((Object)((Object)sound), (String)"sound");
        this.luwrain.playSound(sound);
    }

    @Override
    public UniRefInfo getUniRefInfo(String uniRef) {
        return this.luwrain.getUniRefInfo(uniRef);
    }

    @Override
    public void silence() {
        this.luwrain.silence();
    }

    @Override
    public void setEventResponse(EventResponse eventResponse) {
        NullCheck.notNull((Object)eventResponse, (String)"eventResponse");
        this.luwrain.setEventResponse(eventResponse);
    }

    @Override
    public Clipboard getClipboard() {
        return this.luwrain.getClipboard();
    }

    @Override
    public I18n getI18n() {
        return this.luwrain.i18n();
    }

    @Override
    public int getScreenWidth() {
        return this.luwrain.getScreenWidth();
    }

    @Override
    public int getScreenHeight() {
        return this.luwrain.getScreenHeight();
    }

    @Override
    public void executeBkg(FutureTask task) {
        this.luwrain.executeBkg(task);
    }

    @Override
    public void onAreaNewBackgroundSound(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.luwrain.onAreaNewBackgroundSound(area);
    }

    @Override
    public String getSpeakableText(String text, Luwrain.SpeakableTextType type) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        return this.luwrain.getSpeakableText(text, type);
    }

    @Override
    public boolean runHooks(String hookName, HookContainer.HookRunner runner) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return this.luwrain.runHooks(hookName, runner);
    }

    @Override
    public void message(String text, Luwrain.MessageType messageType) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)((Object)messageType), (String)"messageType");
        this.luwrain.message(text, messageType);
    }

    @Override
    public void runUiSafely(Runnable runnable) {
        NullCheck.notNull((Object)runnable, (String)"runnable");
        this.luwrain.runUiSafely(runnable);
    }
}

