/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.Objects;
import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.EmbeddedEditLines;
import org.luwrain.controls.SingleLineEdit;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class EmbeddedEdit
implements SingleLineEdit.Model {
    protected final ControlContext context;
    protected final SingleLineEdit edit;
    protected final EmbeddedEditLines lines;
    protected final HotPointControl hotPoint;
    protected final ShiftedRegionPoint regionPoint;
    protected int offsetX;
    protected int offsetY;

    public EmbeddedEdit(ControlContext context, EmbeddedEditLines lines, HotPointControl hotPoint, AbstractRegionPoint regionPoint, int offsetX, int offsetY) {
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(lines, "lines can't be null");
        Objects.requireNonNull(hotPoint, "hotPoint can't be null");
        Objects.requireNonNull(regionPoint, "regionPoint can't be null");
        if (offsetX < 0 || offsetY < 0) {
            throw new IllegalArgumentException("offsetX (" + offsetX + ") and offsetY (" + offsetY + ") may not be negative");
        }
        this.context = context;
        this.lines = lines;
        this.hotPoint = hotPoint;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.regionPoint = new ShiftedRegionPoint(regionPoint, offsetX, offsetY);
        this.edit = new SingleLineEdit(context, this, this.regionPoint);
    }

    public SingleLineEdit getEditObj() {
        return this.edit;
    }

    public boolean isPosCovered(int x, int y) {
        return this.offsetY == y && x >= this.offsetX;
    }

    public void setNewOffset(int x, int y) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("x (" + x + ") and y (" + y + ") may not be negative");
        }
        this.offsetX = x;
        this.offsetY = y;
        this.regionPoint.setOffset(x, y);
    }

    public boolean onInputEvent(InputEvent event) {
        return this.edit.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        return this.edit.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        return this.edit.onAreaQuery(query);
    }

    @Override
    public String getLine() {
        return this.lines.getEmbeddedEditLine(this.offsetX, this.offsetY);
    }

    @Override
    public void setLine(String text) {
        this.lines.setEmbeddedEditLine(this.offsetX, this.offsetY, text);
    }

    @Override
    public int getHotPointX() {
        return Math.max(this.hotPoint.getHotPointX() - this.offsetX, 0);
    }

    @Override
    public void setHotPointX(int value) {
        this.hotPoint.setHotPointX(value + this.offsetX);
    }

    @Override
    public String getTabSeq() {
        return "\t";
    }

    protected static final class ShiftedRegionPoint
    implements AbstractRegionPoint {
        protected final AbstractRegionPoint regionPoint;
        protected int offsetX = 0;
        protected int offsetY = 0;

        ShiftedRegionPoint(AbstractRegionPoint regionPoint, int offsetX, int offsetY) {
            Objects.requireNonNull(regionPoint, "regionPoint can't be null");
            if (offsetX < 0 || offsetY < 0) {
                throw new IllegalArgumentException("offsetX (" + offsetX + ") and offsetY (" + offsetY + ") may not be negative");
            }
            this.regionPoint = regionPoint;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        @Override
        public boolean onSystemEvent(SystemEvent event, int hotPointX, int hotPointY) {
            Objects.requireNonNull(event, "event can't be null");
            if (hotPointX < 0 || hotPointY < 0) {
                throw new IllegalArgumentException("hotPointX and hotPointY must be greater or equal to zero");
            }
            if (event.getType() == SystemEvent.Type.REGULAR) {
                switch (event.getCode()) {
                    case REGION_POINT: {
                        this.set(hotPointX, hotPointY);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isInitialized() {
            if (this.regionPoint.getHotPointY() != this.offsetY || this.regionPoint.getHotPointX() < this.offsetX) {
                return false;
            }
            return this.regionPoint.isInitialized();
        }

        @Override
        public void set(int hotPointX, int hotPointY) {
            if (hotPointX < 0 || hotPointY < 0) {
                throw new IllegalArgumentException("hotPointX and hotPointY must be greater or equal to zero");
            }
            this.regionPoint.set(hotPointX + this.offsetX, hotPointY + this.offsetY);
        }

        @Override
        public int getHotPointX() {
            return Math.max(this.regionPoint.getHotPointX() - this.offsetX, 0);
        }

        @Override
        public int getHotPointY() {
            return Math.max(this.regionPoint.getHotPointY() - this.offsetY, 0);
        }

        @Override
        public void reset() {
            this.regionPoint.reset();
        }

        public void setOffset(int x, int y) {
            if (x < 0 || y < 0) {
                throw new IllegalArgumentException("x (" + x + ") and y (" + y + ") may not be negative");
            }
            this.offsetX = x;
            this.offsetY = y;
        }
    }
}

