/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.core.HotPointControl;
import org.luwrain.core.NullCheck;

public class HotPointShift
implements HotPointControl {
    protected final HotPointControl control;
    private int offsetX = 0;
    private int offsetY = 0;

    public HotPointShift(HotPointControl control, int offsetX, int offsetY) {
        NullCheck.notNull((Object)control, (String)"control");
        if (offsetX < 0) {
            throw new IllegalArgumentException("offsetX can't be negative");
        }
        if (offsetY < 0) {
            throw new IllegalArgumentException("offsetY can't be negative");
        }
        this.control = control;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public void beginHotPointTrans() {
        this.control.beginHotPointTrans();
    }

    @Override
    public void endHotPointTrans() {
        this.control.endHotPointTrans();
    }

    @Override
    public int getHotPointX() {
        int value = this.control.getHotPointX();
        return value >= this.offsetX ? value - this.offsetX : 0;
    }

    @Override
    public void setHotPointX(int value) {
        this.control.setHotPointX(value + this.offsetX);
    }

    @Override
    public int getHotPointY() {
        int value = this.control.getHotPointY();
        return value >= this.offsetY ? value - this.offsetY : 0;
    }

    @Override
    public void setHotPointY(int value) {
        this.control.setHotPointY(value + this.offsetY);
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetX(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value can't be negative");
        }
        this.offsetX = value;
    }

    public void setOffsetY(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value can't be negative");
        }
        this.offsetY = value;
    }
}

