/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.core.Clipboard;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;

public class LinesClipboardProvider
implements ClipboardTranslator.Provider {
    protected final Lines lines;
    protected final ClipboardSource clipboardSource;

    public LinesClipboardProvider(Lines lines, ClipboardSource clipboardSource) {
        NullCheck.notNull((Object)lines, (String)"lines");
        NullCheck.notNull((Object)clipboardSource, (String)"clipboardSource");
        this.lines = lines;
        this.clipboardSource = clipboardSource;
    }

    @Override
    public boolean onClipboardCopyAll() {
        ArrayList<String> res = new ArrayList<String>();
        int count = this.lines.getLineCount();
        if (count < 1) {
            this.clipboardSource.getClipboard().set((E[])new String[0]);
            return true;
        }
        for (int i = 0; i < count; ++i) {
            String line = this.lines.getLine(i);
            if (line == null) {
                return false;
            }
            res.add(line);
        }
        this.clipboardSource.getClipboard().set((E[])res.toArray(new String[res.size()]));
        return true;
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        if (withDeleting) {
            return false;
        }
        int count = this.lines.getLineCount();
        if (count < 1) {
            return false;
        }
        if (fromY >= count || toY > count || fromY > toY) {
            return false;
        }
        if (fromY == toY) {
            int toPos;
            String line = this.lines.getLine(fromY);
            if (line == null) {
                return false;
            }
            int fromPos = Math.min(fromX, line.length());
            if (fromPos >= (toPos = Math.min(toX, line.length()))) {
                return false;
            }
            this.clipboardSource.getClipboard().set(line.substring(fromPos, toPos));
            return true;
        }
        ArrayList<String> res = new ArrayList<String>();
        String firstLine = this.lines.getLine(fromY);
        if (firstLine == null) {
            return false;
        }
        res.add(firstLine.substring(Math.min(fromX, firstLine.length())));
        for (int i = fromY + 1; i < toY; ++i) {
            String line = this.lines.getLine(i);
            if (line == null) {
                return false;
            }
            res.add(line);
        }
        String lastLine = this.lines.getLine(toY);
        if (lastLine == null) {
            return false;
        }
        res.add(lastLine.substring(0, Math.min(toX, lastLine.length())));
        this.clipboardSource.getClipboard().set((E[])res.toArray(new String[res.size()]));
        return true;
    }

    @Override
    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        return false;
    }

    public static interface ClipboardSource {
        public Clipboard getClipboard();
    }
}

