/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.RegionPoint;
import org.luwrain.controls.RegionTextQueryTranslator;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Clipboard;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.ListeningFinishedEvent;
import org.luwrain.core.events.MoveHotPointEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BeginListeningQuery;
import org.luwrain.util.WordIterator;

public class ListArea<E>
implements Area,
ClipboardTranslator.Provider,
RegionTextQueryTranslator.Provider {
    protected static final Set<Appearance.Flags> NONE_APPEARANCE_FLAGS = EnumSet.noneOf(Appearance.Flags.class);
    protected static final Set<Appearance.Flags> BRIEF_ANNOUNCEMENT_ONLY = EnumSet.of(Appearance.Flags.BRIEF);
    protected final ControlContext context;
    protected final RegionPoint regionPoint = new RegionPoint();
    protected final ClipboardTranslator clipboardTranslator = new ClipboardTranslator(this, this.regionPoint, EnumSet.of(ClipboardTranslator.Flags.ALLOWED_EMPTY, ClipboardTranslator.Flags.ALLOWED_WITHOUT_REGION_POINT));
    protected final RegionTextQueryTranslator regionTextQueryTranslator = new RegionTextQueryTranslator(this, this.regionPoint, EnumSet.noneOf(RegionTextQueryTranslator.Flags.class));
    protected String areaName = "";
    protected final Model<E> listModel;
    protected final Appearance<E> listAppearance;
    protected final Transition listTransition;
    protected final ClipboardSaver<E> listClipboardSaver;
    protected final Set<Flags> listFlags;
    protected ClickHandler<E> listClickHandler = null;
    protected int hotPointX = 0;
    protected int hotPointY = 0;

    public ListArea(Params<E> params) {
        NullCheck.notNull(params, (String)"params");
        NullCheck.notNull((Object)params.context, (String)"params.context");
        NullCheck.notNull(params.model, (String)"params.model");
        NullCheck.notNull(params.appearance, (String)"params.appearance");
        NullCheck.notNull((Object)params.transition, (String)"params.transition");
        NullCheck.notNull(params.clipboardSaver, (String)"params.clipboardSaver");
        NullCheck.notNull((Object)params.name, (String)"params.name");
        NullCheck.notNull(params.flags, (String)"params.flags");
        this.context = params.context;
        this.listModel = params.model;
        this.listAppearance = params.appearance;
        this.listTransition = params.transition;
        this.listClipboardSaver = params.clipboardSaver;
        this.listClickHandler = params.clickHandler;
        this.areaName = params.name;
        this.listFlags = params.flags;
        this.resetHotPoint();
    }

    public void setListClickHandler(ClickHandler<E> clickHandler) {
        this.listClickHandler = clickHandler;
    }

    public Model<E> getListModel() {
        return this.listModel;
    }

    public Appearance<E> getListAppearance() {
        return this.listAppearance;
    }

    public final E selected() {
        int index = this.selectedIndex();
        return index >= 0 && index < this.listModel.getItemCount() ? (E)this.listModel.getItem(index) : null;
    }

    public final int selectedIndex() {
        return this.getExistingItemIndexOnLine(this.hotPointY);
    }

    public boolean select(E obj, boolean announce) {
        NullCheck.notNull(obj, (String)"obj");
        for (int i = 0; i < this.listModel.getItemCount(); ++i) {
            E o = this.listModel.getItem(i);
            if (o == null || obj != o && !obj.equals(o)) continue;
            this.hotPointY = this.getLineIndexByItemIndex(i);
            this.hotPointX = this.listAppearance.getObservableLeftBound(o);
            this.context.onAreaNewHotPoint(this);
            if (announce) {
                this.listAppearance.announceItem(o, NONE_APPEARANCE_FLAGS);
            }
            return true;
        }
        return false;
    }

    public boolean select(int index, boolean announce) {
        if (index < 0 || index >= this.listModel.getItemCount()) {
            return false;
        }
        int emptyCountAbove = this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) ? 1 : 0;
        this.hotPointY = index + emptyCountAbove;
        E item = this.listModel.getItem(index);
        if (item != null) {
            this.hotPointX = this.listAppearance.getObservableLeftBound(item);
            if (announce) {
                this.listAppearance.announceItem(item, NONE_APPEARANCE_FLAGS);
            }
        } else {
            this.hotPointX = 0;
            if (announce) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            }
        }
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public boolean selectEmptyLineBottom(boolean announce) {
        if (!this.listFlags.contains((Object)Flags.EMPTY_LINE_BOTTOM)) {
            return false;
        }
        int emptyCountAbove = this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) ? 1 : 0;
        this.hotPointY = this.listModel.getItemCount() + emptyCountAbove;
        this.hotPointX = 0;
        if (announce) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        }
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public int getExistingItemIndexOnLine(int lineIndex) {
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex is negative (" + lineIndex + ")");
        }
        int res = this.getItemIndexOnLine(lineIndex);
        return res < this.listModel.getItemCount() ? res : -1;
    }

    public int getItemIndexOnLine(int index) {
        int linesTop;
        int n = linesTop = this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) ? 1 : 0;
        if (index < linesTop) {
            return -1;
        }
        if (index - linesTop <= this.listModel.getItemCount()) {
            return index - linesTop;
        }
        return -1;
    }

    public int getLineIndexByItemIndex(int index) {
        int count = this.listModel.getItemCount();
        if (index < 0 || index >= count) {
            return -1;
        }
        int linesTop = this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) ? 1 : 0;
        return index + linesTop;
    }

    public E getItemOnLine(int lineIndex) {
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex may not be negative (" + lineIndex + ")");
        }
        int index = this.getExistingItemIndexOnLine(lineIndex);
        if (index < 0) {
            return null;
        }
        return this.listModel.getItem(index);
    }

    public int getListItemCount() {
        return this.listModel.getItemCount();
    }

    public void reset(boolean announce) {
        this.regionPoint.reset();
        this.resetHotPoint(announce);
    }

    public void resetHotPoint() {
        this.resetHotPoint(false);
    }

    public void resetHotPoint(boolean introduce) {
        this.hotPointY = 0;
        int count = this.listModel.getItemCount();
        if (count < 1) {
            this.hotPointX = 0;
            this.context.onAreaNewHotPoint(this);
            return;
        }
        E item = this.listModel.getItem(0);
        if (item != null) {
            int n = this.hotPointX = item != null ? this.listAppearance.getObservableLeftBound(item) : 0;
            if (introduce) {
                this.listAppearance.announceItem(item, NONE_APPEARANCE_FLAGS);
            }
        } else {
            this.hotPointX = 0;
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        }
        this.context.onAreaNewHotPoint(this);
    }

    public void announceSelected() {
        E item = this.selected();
        if (item != null) {
            this.listAppearance.announceItem(item, NONE_APPEARANCE_FLAGS);
        }
    }

    public void refresh() {
        E previouslySelected = this.selected();
        this.listModel.refresh();
        this.context.onAreaNewContent(this);
        int count = this.listModel.getItemCount();
        if (count == 0) {
            this.hotPointX = 0;
            this.hotPointY = 0;
            this.context.onAreaNewHotPoint(this);
            return;
        }
        if (previouslySelected != null) {
            if (previouslySelected == this.selected()) {
                return;
            }
            if (this.select(previouslySelected, false)) {
                return;
            }
        }
        this.hotPointY = Math.min(this.hotPointY, this.getLineCount() - 1);
        E item = this.getItemOnLine(this.hotPointY);
        if (item != null) {
            this.hotPointX = Math.min(this.hotPointX, this.listAppearance.getObservableRightBound(item));
            this.hotPointX = Math.max(this.hotPointX, this.listAppearance.getObservableLeftBound(item));
        } else {
            this.hotPointX = 0;
        }
        this.context.onAreaNewHotPoint(this);
    }

    public void redraw() {
        E previouslySelected = this.selected();
        this.context.onAreaNewContent(this);
        int count = this.listModel.getItemCount();
        if (count == 0) {
            this.hotPointX = 0;
            this.hotPointY = 0;
            this.context.onAreaNewHotPoint(this);
            return;
        }
        if (previouslySelected != null) {
            if (previouslySelected == this.selected()) {
                return;
            }
            if (this.select(previouslySelected, false)) {
                return;
            }
        }
        this.hotPointY = Math.min(this.hotPointY, this.getLineCount() - 1);
        E item = this.getItemOnLine(this.hotPointY);
        if (item != null) {
            this.hotPointX = Math.min(this.hotPointX, this.listAppearance.getObservableRightBound(item));
            this.hotPointX = Math.max(this.hotPointX, this.listAppearance.getObservableLeftBound(item));
        } else {
            this.hotPointX = 0;
        }
        this.context.onAreaNewHotPoint(this);
    }

    public boolean isEmpty() {
        return this.listModel.getItemCount() <= 0;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!(event.isSpecial() || event.isModified() && !event.withShiftOnly())) {
            return this.onChar(event);
        }
        if (!event.isSpecial() || event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case ARROW_DOWN: {
                return this.onMoveDown(event, false);
            }
            case ARROW_UP: {
                return this.onMoveUp(event, false);
            }
            case ARROW_RIGHT: {
                return this.onMoveRight(event);
            }
            case ARROW_LEFT: {
                return this.onMoveLeft(event);
            }
            case ALTERNATIVE_ARROW_DOWN: {
                return this.onMoveDown(event, true);
            }
            case ALTERNATIVE_ARROW_UP: {
                return this.onMoveUp(event, true);
            }
            case ALTERNATIVE_ARROW_RIGHT: {
                return this.onAltRight(event);
            }
            case ALTERNATIVE_ARROW_LEFT: {
                return this.onAltLeft(event);
            }
            case HOME: {
                return this.onHome(event);
            }
            case END: {
                return this.onEnd(event);
            }
            case ALTERNATIVE_HOME: {
                return this.onAltHome(event);
            }
            case ALTERNATIVE_END: {
                return this.onAltEnd(event);
            }
            case PAGE_DOWN: {
                return this.onPageDown(event, false);
            }
            case PAGE_UP: {
                return this.onPageUp(event, false);
            }
            case ALTERNATIVE_PAGE_DOWN: {
                return this.onPageDown(event, true);
            }
            case ALTERNATIVE_PAGE_UP: {
                return this.onPageUp(event, true);
            }
            case ENTER: {
                return this.onEnter(event);
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case REFRESH: {
                this.refresh();
                return true;
            }
            case INTRODUCE: {
                return this.onAnnounce();
            }
            case ANNOUNCE_LINE: {
                return this.onAnnounceLine();
            }
            case OK: {
                return this.onOk(event);
            }
            case LISTENING_FINISHED: {
                if (event instanceof ListeningFinishedEvent) {
                    return this.onListeningFinishedEvent((ListeningFinishedEvent)event);
                }
                return false;
            }
            case MOVE_HOT_POINT: {
                if (event instanceof MoveHotPointEvent) {
                    return this.onMoveHotPoint((MoveHotPointEvent)event);
                }
                return false;
            }
        }
        return this.clipboardTranslator.onSystemEvent(event, this.hotPointX, this.hotPointY);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 6: {
                if (query instanceof BeginListeningQuery) {
                    return this.onBeginListeningQuery((BeginListeningQuery)query);
                }
                return false;
            }
            case 8: {
                return this.regionTextQueryTranslator.onAreaQuery(query, this.getHotPointX(), this.getHotPointY());
            }
        }
        return false;
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public int getLineCount() {
        int emptyCountTop = this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) ? 1 : 0;
        int emptyCountBottom = this.listFlags.contains((Object)Flags.EMPTY_LINE_BOTTOM) ? 1 : 0;
        int res = this.listModel.getItemCount() + emptyCountTop + emptyCountBottom;
        return res >= 1 ? res : 1;
    }

    @Override
    public String getLine(int index) {
        if (index < 0) {
            return "";
        }
        if (this.isEmpty()) {
            return index == 0 ? this.noContentStr() : "";
        }
        int itemIndex = this.getExistingItemIndexOnLine(index);
        if (itemIndex < 0) {
            return "";
        }
        E res = this.listModel.getItem(itemIndex);
        return res != null ? this.listAppearance.getScreenAppearance(res, NONE_APPEARANCE_FLAGS) : "";
    }

    @Override
    public int getHotPointX() {
        return this.hotPointX >= 0 ? this.hotPointX : 0;
    }

    @Override
    public int getHotPointY() {
        return this.hotPointY >= 0 ? this.hotPointY : 0;
    }

    @Override
    public String getAreaName() {
        NullCheck.notNull((Object)this.areaName, (String)"areaName");
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        NullCheck.notNull((Object)areaName, (String)"areaName");
        this.areaName = areaName;
        this.context.onAreaNewName(this);
    }

    protected boolean onAnnounce() {
        String value;
        if (!this.listFlags.contains((Object)Flags.AREA_ANNOUNCE_SELECTED)) {
            this.context.say(this.getAreaName(), Sounds.INTRO_REGULAR);
            return true;
        }
        String item = this.selected() != null ? ((value = this.listAppearance.getScreenAppearance(this.selected(), EnumSet.noneOf(Appearance.Flags.class)).trim()) != null && !value.trim().isEmpty() ? value : this.selected().toString()) : "";
        if (!item.trim().isEmpty()) {
            this.context.say(this.context.getSpeakableText(item, Luwrain.SpeakableTextType.NATURAL), Sounds.INTRO_REGULAR);
        } else {
            this.context.say(this.getAreaName(), Sounds.INTRO_REGULAR);
        }
        return true;
    }

    protected boolean onAnnounceLine() {
        if (this.isEmpty()) {
            return false;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        this.listAppearance.announceItem(item, NONE_APPEARANCE_FLAGS);
        return true;
    }

    protected boolean onMoveHotPoint(MoveHotPointEvent event) {
        int newY;
        NullCheck.notNull((Object)event, (String)"event");
        int x = event.getNewHotPointX();
        int y = event.getNewHotPointY();
        if (y >= this.getLineCount()) {
            if (event.precisely()) {
                return false;
            }
            newY = this.getLineCount() - 1;
        } else {
            newY = y;
        }
        if (this.getExistingItemIndexOnLine(newY) >= 0) {
            E item = this.listModel.getItem(this.getExistingItemIndexOnLine(newY));
            int leftBound = this.listAppearance.getObservableLeftBound(item);
            int rightBound = this.listAppearance.getObservableRightBound(item);
            if (event.precisely() && (x < leftBound || x > rightBound)) {
                return false;
            }
            this.hotPointY = newY;
            this.hotPointX = x;
            if (this.hotPointX < leftBound) {
                this.hotPointX = leftBound;
            }
            if (this.hotPointX > rightBound) {
                this.hotPointX = rightBound;
            }
            this.context.onAreaNewHotPoint(this);
            return true;
        }
        this.hotPointY = newY;
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onBeginListeningQuery(BeginListeningQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        int index = this.selectedIndex();
        if (index < 0) {
            return false;
        }
        int count = this.listModel.getItemCount();
        if (index >= count) {
            return false;
        }
        E current = this.listModel.getItem(index);
        String text = this.listAppearance.getScreenAppearance(current, NONE_APPEARANCE_FLAGS).substring(Math.max(this.hotPointX, this.listAppearance.getObservableLeftBound(current)), this.listAppearance.getObservableRightBound(current));
        if (text.isEmpty() && index + 1 >= count) {
            return false;
        }
        if (index + 1 < count) {
            E next = this.listModel.getItem(index + 1);
            query.answer(new BeginListeningQuery.Answer(text, new ListeningInfo(index + 1, this.listAppearance.getObservableLeftBound(next))));
        } else {
            query.answer(new BeginListeningQuery.Answer(text, new ListeningInfo(index, this.listAppearance.getObservableRightBound(current))));
        }
        return true;
    }

    protected boolean onListeningFinishedEvent(ListeningFinishedEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!(event.getExtraInfo() instanceof ListeningInfo)) {
            return false;
        }
        ListeningInfo info = (ListeningInfo)event.getExtraInfo();
        int count = this.listModel.getItemCount();
        if (info.itemIndex >= count) {
            return false;
        }
        E item = this.listModel.getItem(info.itemIndex);
        int leftBound = this.listAppearance.getObservableLeftBound(item);
        int rightBound = this.listAppearance.getObservableRightBound(item);
        if (info.pos < leftBound || info.pos > rightBound) {
            return false;
        }
        this.hotPointY = this.getLineIndexByItemIndex(info.itemIndex);
        this.hotPointX = info.pos;
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onChar(InputEvent event) {
        String beginning;
        if (this.noContent()) {
            return true;
        }
        int count = this.listModel.getItemCount();
        char c = Character.toLowerCase(event.getChar());
        if (this.selected() != null) {
            if (this.hotPointX >= this.listAppearance.getObservableRightBound(this.selected())) {
                return false;
            }
            String name = this.getObservableSubstr(this.selected()).toLowerCase();
            int pos = Math.min(this.hotPointX - this.listAppearance.getObservableLeftBound(this.selected()), name.length());
            if (pos < 0) {
                return false;
            }
            beginning = name.substring(0, pos);
        } else {
            beginning = "";
        }
        String mustBegin = beginning + c;
        for (int i = 0; i < count; ++i) {
            String name = this.getObservableSubstr(this.listModel.getItem(i)).toLowerCase();
            if (!name.startsWith(mustBegin)) continue;
            this.hotPointY = this.getLineIndexByItemIndex(i);
            ++this.hotPointX;
            this.listAppearance.announceItem(this.listModel.getItem(this.hotPointY), NONE_APPEARANCE_FLAGS);
            this.context.onAreaNewHotPoint(this);
            return true;
        }
        return false;
    }

    protected boolean onMoveDown(InputEvent event, boolean briefAnnouncement) {
        return this.onTransition(Transition.Type.SINGLE_DOWN, Hint.NO_ITEMS_BELOW, briefAnnouncement);
    }

    protected boolean onMoveUp(InputEvent event, boolean briefAnnouncement) {
        return this.onTransition(Transition.Type.SINGLE_UP, Hint.NO_ITEMS_ABOVE, briefAnnouncement);
    }

    protected boolean onPageDown(InputEvent event, boolean briefAnnouncement) {
        return this.onTransition(Transition.Type.PAGE_DOWN, Hint.NO_ITEMS_BELOW, briefAnnouncement);
    }

    protected boolean onPageUp(InputEvent event, boolean briefAnnouncement) {
        return this.onTransition(Transition.Type.PAGE_UP, Hint.NO_ITEMS_ABOVE, briefAnnouncement);
    }

    protected boolean onEnd(InputEvent event) {
        return this.onTransition(Transition.Type.END, Hint.NO_ITEMS_BELOW, false);
    }

    protected boolean onHome(InputEvent event) {
        return this.onTransition(Transition.Type.HOME, Hint.NO_ITEMS_ABOVE, false);
    }

    protected boolean onTransition(Transition.Type type, Hint hint, boolean briefAnnouncement) {
        Transition.State current;
        int emptyCountTop;
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)((Object)hint), (String)"hint");
        if (this.noContent()) {
            return true;
        }
        int index = this.selectedIndex();
        int count = this.listModel.getItemCount();
        int n = emptyCountTop = this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) ? 1 : 0;
        if (index >= 0) {
            current = new Transition.State(index);
        } else if (this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP) && this.hotPointY == 0) {
            current = new Transition.State(Transition.State.Type.EMPTY_LINE_TOP);
        } else if (this.listFlags.contains((Object)Flags.EMPTY_LINE_BOTTOM) && this.hotPointY == count + emptyCountTop) {
            current = new Transition.State(Transition.State.Type.EMPTY_LINE_BOTTOM);
        } else {
            return false;
        }
        Transition.State newState = this.listTransition.transition(type, current, count, this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP), this.listFlags.contains((Object)Flags.EMPTY_LINE_BOTTOM));
        NullCheck.notNull((Object)newState, (String)"newState");
        switch (newState.type) {
            case NO_TRANSITION: {
                this.context.setEventResponse(DefaultEventResponse.hint(hint));
                return true;
            }
            case EMPTY_LINE_TOP: {
                if (!this.listFlags.contains((Object)Flags.EMPTY_LINE_TOP)) {
                    return false;
                }
                this.hotPointY = 0;
                break;
            }
            case EMPTY_LINE_BOTTOM: {
                if (!this.listFlags.contains((Object)Flags.EMPTY_LINE_BOTTOM)) {
                    return false;
                }
                this.hotPointY = count + emptyCountTop;
                break;
            }
            case ITEM_INDEX: {
                if (newState.itemIndex < 0 || newState.itemIndex >= count) {
                    return false;
                }
                this.hotPointY = newState.itemIndex + emptyCountTop;
                break;
            }
            default: {
                return false;
            }
        }
        this.onNewHotPointY(briefAnnouncement);
        return true;
    }

    protected boolean onMoveRight(InputEvent event) {
        if (this.noContent()) {
            return true;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        if (line == null || line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        int rightBound = this.listAppearance.getObservableRightBound(item);
        if (this.hotPointX >= rightBound) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        ++this.hotPointX;
        this.announceChar(line, this.hotPointX, rightBound);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onMoveLeft(InputEvent event) {
        if (this.noContent()) {
            return true;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        if (line == null || line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        int leftBound = this.listAppearance.getObservableLeftBound(item);
        int rightBound = this.listAppearance.getObservableRightBound(item);
        if (this.hotPointX <= leftBound) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        --this.hotPointX;
        this.announceChar(line, this.hotPointX, rightBound);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onAltRight(InputEvent event) {
        if (this.noContent()) {
            return true;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        NullCheck.notNull((Object)line, (String)"line");
        if (line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        int leftBound = this.listAppearance.getObservableLeftBound(item);
        int rightBound = this.listAppearance.getObservableRightBound(item);
        if (this.hotPointX >= rightBound) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        String subline = line.substring(leftBound, rightBound);
        WordIterator it = new WordIterator(subline, this.hotPointX - leftBound);
        if (!it.stepForward()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        this.hotPointX = it.pos() + leftBound;
        if (it.announce().length() > 0) {
            this.context.setEventResponse(DefaultEventResponse.text(it.announce()));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        }
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onAltLeft(InputEvent event) {
        if (this.noContent()) {
            return true;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        if (line == null || line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        int leftBound = this.listAppearance.getObservableLeftBound(item);
        int rightBound = this.listAppearance.getObservableRightBound(item);
        if (this.hotPointX <= leftBound) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        String subline = line.substring(leftBound, rightBound);
        WordIterator it = new WordIterator(subline, this.hotPointX - leftBound);
        if (!it.stepBackward()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        this.hotPointX = it.pos() + leftBound;
        this.context.setEventResponse(DefaultEventResponse.text(it.announce()));
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onAltEnd(InputEvent event) {
        if (this.noContent()) {
            return true;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        NullCheck.notNull((Object)line, (String)"line");
        this.hotPointX = this.listAppearance.getObservableRightBound(item);
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.LINE_BOUND));
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onAltHome(InputEvent event) {
        if (this.noContent()) {
            return true;
        }
        E item = this.selected();
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        NullCheck.notNull((Object)line, (String)"line");
        this.hotPointX = this.listAppearance.getObservableLeftBound(item);
        this.announceChar(line, this.hotPointX, this.listAppearance.getObservableRightBound(item));
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onEnter(InputEvent event) {
        if (this.isEmpty() || this.listClickHandler == null) {
            return false;
        }
        if (this.selected() == null || this.selectedIndex() < 0) {
            return false;
        }
        if (!this.listClickHandler.onListClick(this, this.selectedIndex(), this.selected())) {
            return false;
        }
        this.redraw();
        return true;
    }

    protected boolean onOk(SystemEvent event) {
        if (this.listClickHandler == null) {
            return false;
        }
        int index = this.selectedIndex();
        E item = this.selected();
        if (index < 0 || item == null) {
            return false;
        }
        if (!this.listClickHandler.onListClick(this, index, item)) {
            return false;
        }
        this.redraw();
        return true;
    }

    @Override
    public String onRegionTextQuery(int fromX, int fromY, int toX, int toY) {
        if (this.isEmpty()) {
            return null;
        }
        if (fromX < 0 || fromY < 0 || fromX == toX && fromY == toY) {
            int index = this.getExistingItemIndexOnLine(toY);
            if (index < 0) {
                return null;
            }
            return this.listAppearance.getScreenAppearance(this.listModel.getItem(index), NONE_APPEARANCE_FLAGS);
        }
        int modelFromY = this.getExistingItemIndexOnLine(fromY);
        int modelToY = this.getItemIndexOnLine(toY);
        if (modelFromY < 0 || modelToY < 0) {
            return null;
        }
        if (modelFromY == modelToY) {
            int toPos;
            String line = this.listAppearance.getScreenAppearance(this.listModel.getItem(modelFromY), NONE_APPEARANCE_FLAGS);
            if (line == null || line.isEmpty()) {
                return null;
            }
            int fromPos = Math.min(fromX, line.length());
            if (fromPos >= (toPos = Math.min(toX, line.length()))) {
                return null;
            }
            return line.substring(fromPos, toPos);
        }
        StringBuilder b = new StringBuilder();
        b.append(this.listAppearance.getScreenAppearance(this.listModel.getItem(fromY), NONE_APPEARANCE_FLAGS));
        for (int i = fromY + 1; i < toY; ++i) {
            b.append("\n" + this.listAppearance.getScreenAppearance(this.listModel.getItem(i), NONE_APPEARANCE_FLAGS));
        }
        return new String(b);
    }

    @Override
    public boolean onClipboardCopyAll() {
        if (this.isEmpty()) {
            return false;
        }
        return this.listClipboardSaver.saveToClipboard(this, this.listModel, this.listAppearance, 0, this.listModel.getItemCount(), this.context.getClipboard());
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        if (this.isEmpty() || withDeleting) {
            return false;
        }
        if (fromX < 0 || fromY < 0 || fromX == toX && fromY == toY) {
            int index = this.getExistingItemIndexOnLine(toY);
            if (index < 0) {
                return false;
            }
            return this.listClipboardSaver.saveToClipboard(this, this.listModel, this.listAppearance, index, index + 1, this.context.getClipboard());
        }
        int modelFromY = this.getExistingItemIndexOnLine(fromY);
        int modelToY = this.getItemIndexOnLine(toY);
        if (modelFromY < 0 || modelToY < 0) {
            return false;
        }
        if (modelFromY == modelToY) {
            int toPos;
            String line = this.listAppearance.getScreenAppearance(this.listModel.getItem(modelFromY), EnumSet.of(Appearance.Flags.CLIPBOARD));
            if (line == null || line.isEmpty()) {
                return false;
            }
            int fromPos = Math.min(fromX, line.length());
            if (fromPos >= (toPos = Math.min(toX, line.length()))) {
                return false;
            }
            this.context.getClipboard().set(line.substring(fromPos, toPos));
            return true;
        }
        return this.listClipboardSaver.saveToClipboard(this, this.listModel, this.listAppearance, modelFromY, modelToY, this.context.getClipboard());
    }

    @Override
    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        return false;
    }

    protected void onNewHotPointY(boolean briefAnnouncement) {
        int index = this.selectedIndex();
        if (index < 0) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            this.hotPointX = 0;
            this.context.onAreaNewHotPoint(this);
            return;
        }
        E item = this.listModel.getItem(index);
        if (item == null) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            this.hotPointX = 0;
            this.context.onAreaNewHotPoint(this);
            return;
        }
        this.listAppearance.announceItem(item, briefAnnouncement ? BRIEF_ANNOUNCEMENT_ONLY : NONE_APPEARANCE_FLAGS);
        this.hotPointX = this.listAppearance.getObservableLeftBound(item);
        this.context.onAreaNewHotPoint(this);
    }

    protected String getObservableSubstr(E item) {
        int rightBound;
        NullCheck.notNull(item, (String)"item");
        String line = this.listAppearance.getScreenAppearance(item, NONE_APPEARANCE_FLAGS);
        NullCheck.notNull((Object)line, (String)"line");
        if (line.isEmpty()) {
            return "";
        }
        int leftBound = Math.min(this.listAppearance.getObservableLeftBound(item), line.length());
        if (leftBound >= (rightBound = Math.min(this.listAppearance.getObservableRightBound(item), line.length()))) {
            return "";
        }
        return line.substring(leftBound, rightBound);
    }

    protected String noContentStr() {
        return this.context.getStaticStr("ListNoContent");
    }

    protected void announceChar(String line, int pos, int rightBound) {
        NullCheck.notNull((Object)line, (String)"line");
        if (pos < rightBound) {
            this.context.setEventResponse(DefaultEventResponse.letter(line.charAt(pos)));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.LINE_BOUND));
        }
    }

    protected boolean noContent() {
        if (this.listModel == null || this.listModel.getItemCount() < 1) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_CONTENT, this.noContentStr()));
            return true;
        }
        return false;
    }

    public static interface ClickHandler<E> {
        public boolean onListClick(ListArea<E> var1, int var2, E var3);
    }

    public static class Params<E> {
        public ControlContext context = null;
        public Model<E> model = null;
        public Appearance<E> appearance = null;
        public ClickHandler<E> clickHandler;
        public Transition transition = new ListUtils.DefaultTransition();
        public ClipboardSaver<E> clipboardSaver = new ListUtils.DefaultClipboardSaver();
        public String name = null;
        public Set<Flags> flags = EnumSet.of(Flags.EMPTY_LINE_BOTTOM);
    }

    public static interface Model<E> {
        public int getItemCount();

        public E getItem(int var1);

        public void refresh();
    }

    public static interface Appearance<E> {
        public void announceItem(E var1, Set<Flags> var2);

        public String getScreenAppearance(E var1, Set<Flags> var2);

        public int getObservableLeftBound(E var1);

        public int getObservableRightBound(E var1);

        public static enum Flags {
            BRIEF,
            CLIPBOARD;

        }
    }

    public static interface Transition {
        public State transition(Type var1, State var2, int var3, boolean var4, boolean var5);

        public static final class State {
            public final Type type;
            public final int itemIndex;

            public State(Type type) {
                NullCheck.notNull((Object)((Object)type), (String)"type");
                this.type = type;
                this.itemIndex = -1;
            }

            public State(int itemIndex) {
                this.type = Type.ITEM_INDEX;
                this.itemIndex = itemIndex;
            }

            public static enum Type {
                EMPTY_LINE_TOP,
                EMPTY_LINE_BOTTOM,
                ITEM_INDEX,
                NO_TRANSITION;

            }
        }

        public static enum Type {
            SINGLE_DOWN,
            SINGLE_UP,
            PAGE_DOWN,
            PAGE_UP,
            HOME,
            END;

        }
    }

    public static interface ClipboardSaver<E> {
        public boolean saveToClipboard(ListArea<E> var1, Model<E> var2, Appearance<E> var3, int var4, int var5, Clipboard var6);
    }

    public static enum Flags {
        EMPTY_LINE_TOP,
        EMPTY_LINE_BOTTOM,
        AREA_ANNOUNCE_SELECTED;

    }

    protected static class ListeningInfo {
        final int itemIndex;
        final int pos;

        ListeningInfo(int itemIndex, int pos) {
            this.itemIndex = itemIndex;
            this.pos = pos;
        }
    }
}

