/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;

public class MutableLinesImpl
extends ArrayList<String>
implements MutableLines {
    public MutableLinesImpl() {
    }

    public MutableLinesImpl(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.addAll(Arrays.asList(lines));
    }

    @Override
    public void update(MutableLines.Updating updating) {
        NullCheck.notNull((Object)updating, (String)"updating");
        updating.update(this);
    }

    @Override
    public int getLineCount() {
        return this.size();
    }

    @Override
    public String getLine(int index) {
        if (index < 0 || index >= this.size()) {
            return "";
        }
        return (String)this.get(index);
    }

    @Override
    public void setLines(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.clear();
        this.addAll(Arrays.asList(lines));
    }

    @Override
    public String[] getLinesAsArray() {
        return this.toArray(new String[this.size()]);
    }

    @Override
    public List<String> getLines() {
        return this;
    }

    @Override
    public void setLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (index < 0) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + " can't be negative");
        }
        if (index >= this.size()) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + ") can't be greater or equal to line count (" + String.valueOf(this.size()) + ")");
        }
        this.set(index, line);
    }

    @Override
    public void removeLine(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Invalid index (" + index + ")");
        }
        this.remove(index);
    }

    public String getWholeText(String lineSep) {
        String s = lineSep != null ? lineSep : System.lineSeparator();
        return this.stream().collect(Collectors.joining(s));
    }

    public String getWholeText() {
        return this.getWholeText(null);
    }
}

