/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.luwrain.core.LineMarks;
import org.luwrain.core.MutableLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;

public class MutableMarkedLinesImpl
extends ArrayList<Line>
implements MutableMarkedLines {
    public MutableMarkedLinesImpl() {
    }

    public MutableMarkedLinesImpl(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        for (String s : lines) {
            this.add(new Line(s));
        }
    }

    @Override
    public void update(MutableLines.Updating updating) {
        NullCheck.notNull((Object)updating, (String)"updating");
        updating.update(this);
    }

    @Override
    public int getLineCount() {
        return this.size();
    }

    @Override
    public String getLine(int index) {
        if (index < 0 || index >= this.size()) {
            return "";
        }
        return ((Line)this.get((int)index)).text;
    }

    @Override
    public void setLines(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.clear();
        this.ensureCapacity(lines.length);
        for (String l : lines) {
            this.add(new Line(l));
        }
    }

    @Override
    public String[] getLinesAsArray() {
        ArrayList<String> res = new ArrayList<String>();
        res.ensureCapacity(this.size());
        for (int i = 0; i < this.size(); ++i) {
            res.add(((Line)this.get((int)i)).text);
        }
        return res.toArray(new String[res.size()]);
    }

    @Override
    public List<String> getLines() {
        ArrayList<String> res = new ArrayList<String>();
        res.ensureCapacity(this.size());
        for (int i = 0; i < this.size(); ++i) {
            res.add(((Line)this.get((int)i)).text);
        }
        return res;
    }

    @Override
    public void setLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (index < 0) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + " can't be negative");
        }
        if (index >= this.size()) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + ") can't be greater or equal to line count (" + String.valueOf(this.size()) + ")");
        }
        this.set(index, new Line(line));
    }

    @Override
    public boolean add(String line) {
        NullCheck.notNull((Object)line, (String)"line");
        this.add(new Line(line));
        return true;
    }

    @Override
    public void add(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (index < 0 || index > this.size()) {
            throw new IllegalArgumentException("Illegal index value (" + index + ")");
        }
        if (index < this.size()) {
            this.add(index, new Line(line));
        } else {
            this.add(new Line(line));
        }
    }

    @Override
    public void removeLine(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Invalid index (" + index + ")");
        }
        this.remove(index);
    }

    @Override
    public LineMarks getLineMarks(int index) {
        return ((Line)this.get((int)index)).marks;
    }

    @Override
    public void setLineMarks(int index, LineMarks marks) {
        ((Line)this.get((int)index)).marks = marks;
    }

    public String getText(String lineSep) {
        String s;
        String string = s = lineSep != null ? lineSep : System.lineSeparator();
        if (this.size() == 0) {
            return "";
        }
        if (this.size() == 1) {
            return ((Line)this.get((int)0)).text;
        }
        StringBuilder res = new StringBuilder();
        res.append(((Line)this.get((int)0)).text);
        for (int i = 1; i < this.size(); ++i) {
            res.append(s).append(((Line)this.get((int)i)).text);
        }
        return new String(res);
    }

    public static final class Line {
        final String text;
        LineMarks marks = null;

        public Line(String text) {
            Objects.requireNonNull(text, "text can't be null");
            this.text = text;
        }
    }
}

