/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.EnumSet;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultTableAppearance;
import org.luwrain.controls.LinesClipboardProvider;
import org.luwrain.controls.RegionPoint;
import org.luwrain.controls.TableCell;
import org.luwrain.controls.TableClickHandler;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.i18n.LangStatic;

public class TableArea
implements Area {
    public static final int INTRODUCTION_BRIEF = 1;
    protected final ControlContext environment;
    protected final RegionPoint regionPoint = new RegionPoint();
    protected final ClipboardTranslator clipboardTranslator;
    protected String name = "";
    protected final Model model;
    protected final Appearance appearance;
    protected TableClickHandler clickHandler = null;
    private int initialHotPointX = 0;
    private int hotPointX = 0;
    private int hotPointY = 0;
    private int[] colWidth;
    private int cellShift = 0;

    public TableArea(ControlContext environment, Model model) {
        NullCheck.notNull((Object)environment, (String)"environment");
        NullCheck.notNull((Object)model, (String)"model");
        this.environment = environment;
        this.model = model;
        this.appearance = new DefaultTableAppearance(environment);
        this.initialHotPointX = this.appearance.getInitialHotPointX(model);
        this.clipboardTranslator = new ClipboardTranslator(new LinesClipboardProvider(this, () -> environment.getClipboard()), this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
    }

    public TableArea(ControlContext environment, Model model, String name) {
        this.environment = environment;
        this.model = model;
        this.name = name;
        if (environment == null) {
            throw new NullPointerException("environment may not be null");
        }
        if (model == null) {
            throw new NullPointerException("model may not be null");
        }
        if (name == null) {
            throw new NullPointerException("name may not be null");
        }
        this.appearance = new DefaultTableAppearance(environment);
        this.initialHotPointX = this.appearance.getInitialHotPointX(model);
        this.clipboardTranslator = new ClipboardTranslator(new LinesClipboardProvider(this, () -> environment.getClipboard()), this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
    }

    public TableArea(ControlContext environment, Model model, Appearance appearance, TableClickHandler clickHandler, String name) {
        this.environment = environment;
        this.model = model;
        this.appearance = appearance != null ? appearance : new DefaultTableAppearance(environment);
        this.name = name != null ? name : "";
        this.clickHandler = clickHandler;
        this.initialHotPointX = appearance.getInitialHotPointX(model);
        if (environment == null) {
            throw new NullPointerException("environment may not be null");
        }
        if (model == null) {
            throw new NullPointerException("model may not be null");
        }
        if (appearance == null) {
            throw new NullPointerException("appearance may not be null");
        }
        if (name == null) {
            throw new NullPointerException("name may not be null");
        }
        this.clipboardTranslator = new ClipboardTranslator(new LinesClipboardProvider(this, () -> environment.getClipboard()), this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
    }

    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean refreshModel) {
        if (this.model == null) {
            this.colWidth = null;
            this.cellShift = 0;
            this.hotPointX = 0;
            this.hotPointY = 0;
            this.environment.onAreaNewContent(this);
            this.environment.onAreaNewHotPoint(this);
            return;
        }
        if (refreshModel) {
            this.model.refresh();
        }
        int colCount = this.model.getColCount();
        int rowCount = this.model.getRowCount();
        if (colCount <= 0 || rowCount <= 0) {
            this.colWidth = null;
            this.cellShift = 0;
            this.hotPointX = 0;
            this.hotPointY = 0;
            this.environment.onAreaNewContent(this);
            this.environment.onAreaNewHotPoint(this);
            return;
        }
        this.initialHotPointX = this.appearance.getInitialHotPointX(this.model);
        this.colWidth = new int[colCount];
        int totalWidth = this.initialHotPointX;
        for (int i = 0; i < colCount; ++i) {
            int width = this.appearance.getColWidth(this.model, i);
            this.colWidth[i] = width >= 1 ? width : 1;
            totalWidth += this.colWidth[i] + 1;
        }
        if (this.hotPointY > rowCount) {
            this.hotPointY = rowCount;
        }
        if (this.hotPointY < rowCount && this.hotPointX >= totalWidth) {
            this.hotPointX = totalWidth - 1;
        }
        if (this.hotPointY == rowCount) {
            this.hotPointX = 0;
        }
        this.environment.onAreaNewContent(this);
        this.environment.onAreaNewHotPoint(this);
    }

    public Object getSelectedRow() {
        int index = this.getSelectedRowIndex();
        if (index < 0) {
            return null;
        }
        return this.model.getRow(index);
    }

    public Object getSelectedCol() {
        return null;
    }

    public Object getSelectedCell() {
        return null;
    }

    public int getSelectedRowIndex() {
        return this.hotPointY < this.model.getRowCount() ? this.hotPointY : -1;
    }

    public int getSelectedColIndex() {
        return -1;
    }

    public void setClickHandler(TableClickHandler clickHandler) {
        this.clickHandler = clickHandler;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        if (event == null) {
            throw new NullPointerException("event may not be null");
        }
        if (!event.isSpecial() || event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case ARROW_DOWN: {
                return this.onArrowDown(event, false);
            }
            case ARROW_UP: {
                return this.onArrowUp(event, false);
            }
            case ARROW_RIGHT: {
                return this.onArrowRight(event);
            }
            case ARROW_LEFT: {
                return this.onArrowLeft(event);
            }
            case ALTERNATIVE_ARROW_DOWN: {
                return this.onArrowDown(event, true);
            }
            case ALTERNATIVE_ARROW_UP: {
                return this.onArrowUp(event, true);
            }
            case HOME: {
                return this.onHome(event);
            }
            case END: {
                return this.onEnd(event);
            }
            case ALTERNATIVE_HOME: {
                return this.onLineHome(event);
            }
            case ALTERNATIVE_END: {
                return this.onLineEnd(event);
            }
            case PAGE_DOWN: {
                return this.onPageDown(event, false);
            }
            case PAGE_UP: {
                return this.onPageUp(event, false);
            }
            case ALTERNATIVE_PAGE_DOWN: {
                return this.onPageDown(event, true);
            }
            case ALTERNATIVE_PAGE_UP: {
                return this.onPageUp(event, true);
            }
            case ENTER: {
                if (this.noProperContent() || this.clickHandler == null || this.hotPointY < 0 || this.hotPointY >= this.model.getRowCount() || this.getColUnderPos(this.hotPointX) < 0) {
                    return false;
                }
                return this.clickHandler.onClick(this.model, this.getColUnderPos(this.hotPointX), this.hotPointY, this.model.getCell(this.getColUnderPos(this.hotPointX), this.hotPointY));
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        if (event == null) {
            throw new NullPointerException("event may not be null");
        }
        switch (event.getCode()) {
            case REFRESH: {
                this.refresh();
                return true;
            }
        }
        return this.clipboardTranslator.onSystemEvent(event, this.hotPointX, this.hotPointY);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        return false;
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public int getLineCount() {
        if (this.noProperContent()) {
            return 2;
        }
        return this.model.getRowCount() + 1;
    }

    @Override
    public String getLine(int index) {
        if (this.noProperContent()) {
            return index <= 0 ? this.environment.staticStr(LangStatic.TABLE_NO_CONTENT) : "";
        }
        if (index < 0 || index >= this.model.getRowCount()) {
            return "";
        }
        int currentCol = this.getColUnderPos(this.hotPointX);
        Object line = this.getStringOfLen(this.appearance.getRowPrefix(this.model, index), this.initialHotPointX, "", "");
        if (index != this.hotPointY || currentCol < 0) {
            for (int i = 0; i < this.model.getColCount(); ++i) {
                line = (String)line + this.getStringOfLen(this.appearance.getCellText(this.model, i, index), this.colWidth[i], ">", " ");
            }
            return line;
        }
        if (currentCol > 0) {
            for (int i = 0; i < currentCol; ++i) {
                line = (String)line + this.getStringOfLen(this.appearance.getCellText(this.model, i, index), this.colWidth[i], ">", " ");
            }
        }
        String currentColText = this.appearance.getCellText(this.model, currentCol, index);
        if (this.cellShift > 0 && this.cellShift < currentColText.length()) {
            currentColText = currentColText.substring(this.cellShift);
        }
        line = (String)line + this.getStringOfLen(currentColText, this.colWidth[currentCol], ">", " ");
        if (currentCol + 1 < this.colWidth.length) {
            for (int i = currentCol + 1; i < this.colWidth.length; ++i) {
                line = (String)line + this.getStringOfLen(this.appearance.getCellText(this.model, i, index), this.colWidth[i], ">", " ");
            }
        }
        return line;
    }

    @Override
    public int getHotPointX() {
        return this.hotPointX >= 0 ? this.hotPointX : 0;
    }

    @Override
    public int getHotPointY() {
        return this.hotPointY >= 0 ? this.hotPointY : 0;
    }

    @Override
    public String getAreaName() {
        return this.name;
    }

    public void setName(String value) {
        if (value == null) {
            throw new NullPointerException("value may not be null");
        }
        this.name = value;
        this.environment.onAreaNewName(this);
    }

    private boolean onArrowDown(InputEvent event, boolean briefIntroduction) {
        if (this.noContentCheck()) {
            return true;
        }
        int count = this.model.getRowCount();
        if (this.hotPointY >= count) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_NO_ROWS_BELOW));
            return true;
        }
        ++this.hotPointY;
        this.onNewHotPointY(briefIntroduction);
        return true;
    }

    private boolean onArrowUp(InputEvent event, boolean briefIntroduction) {
        if (this.noContentCheck()) {
            return true;
        }
        int count = this.model.getRowCount();
        if (this.hotPointY <= 0) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_NO_ROWS_ABOVE));
            return true;
        }
        --this.hotPointY;
        if (this.hotPointY >= count) {
            this.hotPointY = count - 1;
        }
        this.onNewHotPointY(briefIntroduction);
        return true;
    }

    private boolean onPageDown(InputEvent event, boolean briefIntroduction) {
        if (this.noContentCheck()) {
            return true;
        }
        int count = this.model.getRowCount();
        if (this.hotPointY >= count) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_NO_ROWS_BELOW));
            return true;
        }
        this.hotPointY += this.environment.getAreaVisibleHeight(this);
        if (this.hotPointY >= count) {
            this.hotPointY = count;
        }
        this.onNewHotPointY(briefIntroduction);
        return true;
    }

    private boolean onPageUp(InputEvent event, boolean briefIntroduction) {
        if (this.noContentCheck()) {
            return true;
        }
        if (this.hotPointY <= 0) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_NO_ROWS_ABOVE));
            return true;
        }
        this.hotPointY -= this.environment.getAreaVisibleHeight(this);
        if (this.hotPointY < 0) {
            this.hotPointY = 0;
        }
        this.onNewHotPointY(briefIntroduction);
        return true;
    }

    private boolean onEnd(InputEvent event) {
        int count;
        if (this.noContentCheck()) {
            return true;
        }
        this.hotPointY = count = this.model.getRowCount();
        this.onNewHotPointY(false);
        return true;
    }

    private boolean onHome(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        this.hotPointY = 0;
        this.onNewHotPointY(false);
        return true;
    }

    private boolean onArrowRight(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        int count = this.model.getRowCount();
        if (this.hotPointY < 0 || this.hotPointY >= count) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.hotPointX < this.initialHotPointX) {
            this.hotPointX = this.initialHotPointX;
        }
        if (this.getColUnderPos(this.hotPointX) < 0) {
            this.hotPointX = this.initialHotPointX;
        }
        int currentCol = this.getColUnderPos(this.hotPointX);
        int currentColWidth = this.colWidth[currentCol];
        int colStartPos = this.getColStartPos(currentCol);
        int nextColStartPos = colStartPos + this.colWidth[currentCol] + 1;
        TableCell c = new TableCell(this.hotPointX - colStartPos, this.cellShift, currentColWidth, this.appearance.getCellText(this.model, currentCol, this.hotPointY));
        if (!c.moveNext()) {
            if (currentCol + 1 >= this.colWidth.length) {
                this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_END_OF_ROW));
                return true;
            }
            this.cellShift = 0;
            this.hotPointX = nextColStartPos;
            String nextColText = this.appearance.getCellText(this.model, currentCol + 1, this.hotPointY);
            if (!nextColText.isEmpty()) {
                this.environment.sayLetter(nextColText.charAt(0));
            } else {
                this.environment.setEventResponse(DefaultEventResponse.hint(currentCol + 2 < this.colWidth.length ? Hint.TABLE_END_OF_COL : Hint.TABLE_END_OF_ROW));
            }
            this.environment.onAreaNewContent(this);
            this.environment.onAreaNewHotPoint(this);
            return true;
        }
        this.cellShift = c.shift;
        this.hotPointX = c.pos + colStartPos;
        if (c.pos + c.shift >= c.line.length()) {
            this.environment.setEventResponse(DefaultEventResponse.hint(currentCol + 1 < this.colWidth.length ? Hint.TABLE_END_OF_COL : Hint.TABLE_END_OF_ROW));
        } else {
            this.environment.sayLetter(c.line.charAt(c.pos + c.shift));
        }
        this.environment.onAreaNewContent(this);
        this.environment.onAreaNewHotPoint(this);
        return true;
    }

    private boolean onArrowLeft(InputEvent event) {
        if (this.noContentCheck()) {
            return true;
        }
        int count = this.model.getRowCount();
        if (this.hotPointY < 0 || this.hotPointY >= count) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.hotPointX < this.initialHotPointX) {
            this.hotPointX = this.initialHotPointX;
        }
        if (this.getColUnderPos(this.hotPointX) < 0) {
            this.hotPointX = this.initialHotPointX;
        }
        int currentCol = this.getColUnderPos(this.hotPointX);
        int currentColWidth = this.colWidth[currentCol];
        int colStartPos = this.getColStartPos(currentCol);
        TableCell c = new TableCell(this.hotPointX - colStartPos, this.cellShift, currentColWidth, this.appearance.getCellText(this.model, currentCol, this.hotPointY));
        if (!c.movePrev()) {
            if (currentCol <= 0) {
                this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_BEGIN_OF_ROW));
                return true;
            }
            String prevColText = this.appearance.getCellText(this.model, currentCol - 1, this.hotPointY);
            int prevColWidth = this.colWidth[currentCol - 1];
            int prevColStartPos = this.getColStartPos(currentCol - 1);
            if (prevColText.length() > prevColWidth) {
                this.hotPointX = prevColStartPos + prevColWidth;
                this.cellShift = prevColText.length() - prevColWidth;
            } else {
                this.cellShift = 0;
                this.hotPointX = prevColStartPos + prevColText.length();
            }
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_END_OF_COL));
            this.environment.onAreaNewContent(this);
            this.environment.onAreaNewHotPoint(this);
            return true;
        }
        this.cellShift = c.shift;
        this.hotPointX = c.pos + colStartPos;
        if (c.pos == c.width) {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.TABLE_END_OF_COL));
        } else {
            this.environment.sayLetter(c.line.charAt(c.pos + c.shift));
        }
        this.environment.onAreaNewContent(this);
        this.environment.onAreaNewHotPoint(this);
        return true;
    }

    private boolean onLineEnd(InputEvent event) {
        return this.noContentCheck();
    }

    private boolean onLineHome(InputEvent event) {
        return this.noContentCheck();
    }

    private void onNewHotPointY(boolean briefIntroduction) {
        int count = this.model.getRowCount();
        this.hotPointX = this.hotPointY < count ? this.initialHotPointX : 0;
        this.cellShift = 0;
        this.environment.onAreaNewHotPoint(this);
        if (this.hotPointY < count) {
            this.appearance.announceRow(this.model, this.hotPointY, briefIntroduction ? 1 : 0);
        } else {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        }
    }

    private void copyEntireContent() {
    }

    private boolean noProperContent() {
        return this.model == null || this.model.getRowCount() <= 0 || this.model.getColCount() <= 0 || this.colWidth == null || this.colWidth.length <= 0;
    }

    private boolean noContentCheck() {
        if (!this.noProperContent()) {
            return false;
        }
        this.environment.setEventResponse(DefaultEventResponse.hint(Hint.NO_CONTENT, this.environment.staticStr(LangStatic.TABLE_NO_CONTENT)));
        return true;
    }

    private String getStringOfLen(String value, int requiredLen, String suffixLonger, String suffixEnoughRoom) {
        Object v;
        Object object = v = value != null ? value : "";
        if (((String)v).length() > requiredLen) {
            return ((String)v).substring(0, requiredLen) + suffixLonger;
        }
        while (((String)v).length() < requiredLen) {
            v = (String)v + " ";
        }
        return (String)v + suffixEnoughRoom;
    }

    private int getColUnderPos(int pos) {
        if (this.hotPointX < this.initialHotPointX) {
            return -1;
        }
        if (this.colWidth == null || this.colWidth.length < 1) {
            return 0;
        }
        int shift = this.initialHotPointX;
        for (int i = 0; i < this.colWidth.length; ++i) {
            if (pos >= shift && pos <= shift + this.colWidth[i]) {
                return i;
            }
            shift += this.colWidth[i] + 1;
        }
        return -1;
    }

    private int getColStartPos(int colIndex) {
        int value = this.initialHotPointX;
        for (int i = 0; i < colIndex; ++i) {
            value += this.colWidth[i] + 1;
        }
        return value;
    }

    public static interface Model {
        public int getRowCount();

        public int getColCount();

        public Object getCell(int var1, int var2);

        public Object getRow(int var1);

        public Object getCol(int var1);

        public void refresh();
    }

    public static interface Appearance {
        public void announceRow(Model var1, int var2, int var3);

        public int getInitialHotPointX(Model var1);

        public String getCellText(Model var1, int var2, int var3);

        public String getRowPrefix(Model var1, int var2);

        public int getColWidth(Model var1, int var2);
    }
}

