/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.Objects;
import org.luwrain.controls.edit.MultilineEdit;

public abstract class MultilineEditModelChangeListener
implements MultilineEdit.Model {
    protected final MultilineEdit.Model model;

    public MultilineEditModelChangeListener(MultilineEdit.Model model) {
        Objects.requireNonNull(model, "model can't be null");
        this.model = model;
    }

    public abstract void onAfterMultilineEditChange();

    @Override
    public int getLineCount() {
        return this.model.getLineCount();
    }

    @Override
    public String getLine(int index) {
        return this.model.getLine(index);
    }

    @Override
    public int getHotPointX() {
        return this.model.getHotPointX();
    }

    @Override
    public int getHotPointY() {
        return this.model.getHotPointY();
    }

    @Override
    public String getTabSeq() {
        return this.model.getTabSeq();
    }

    @Override
    public MultilineEdit.ModificationResult deleteChar(int pos, int lineIndex) {
        MultilineEdit.ModificationResult res = this.model.deleteChar(pos, lineIndex);
        if (res.isPerformed()) {
            this.onAfterMultilineEditChange();
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult deleteRegion(int fromX, int fromY, int toX, int toY) {
        MultilineEdit.ModificationResult res = this.model.deleteRegion(fromX, fromY, toX, toY);
        if (res.isPerformed()) {
            this.onAfterMultilineEditChange();
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult insertRegion(int x, int y, String[] lines) {
        MultilineEdit.ModificationResult res = this.model.insertRegion(x, y, lines);
        if (res.isPerformed()) {
            this.onAfterMultilineEditChange();
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult putChars(int pos, int lineIndex, String str) {
        MultilineEdit.ModificationResult res = this.model.putChars(pos, lineIndex, str);
        if (res.isPerformed()) {
            this.onAfterMultilineEditChange();
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult mergeLines(int firstLineIndex) {
        MultilineEdit.ModificationResult res = this.model.mergeLines(firstLineIndex);
        if (res.isPerformed()) {
            this.onAfterMultilineEditChange();
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult splitLine(int pos, int lineIndex) {
        MultilineEdit.ModificationResult res = this.model.splitLine(pos, lineIndex);
        if (res.isPerformed()) {
            this.onAfterMultilineEditChange();
        }
        return res;
    }
}

