/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.wizard;

import groovy.lang.Closure;
import org.luwrain.controls.WizardArea;
import org.luwrain.controls.wizard.WizardGroovyController;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public class FrameDelegate {
    final WizardGroovyController controller;
    final WizardArea.Frame frame;

    public FrameDelegate(WizardGroovyController controller, WizardArea.Frame frame) {
        NullCheck.notNull((Object)controller, (String)"controller");
        NullCheck.notNull((Object)frame, (String)"frame");
        this.controller = controller;
        this.frame = frame;
    }

    public void text(String value) {
        this.frame.addText(value);
    }

    public void input(String id, String title, String value) {
        NullCheck.notEmpty((Object)id, (String)"id");
        NullCheck.notNull((Object)title, (String)"title");
        this.frame.addInput(title, value != null ? value : "");
    }

    public void input(String id, String title) {
        this.input(id, title, null);
    }

    public void button(String title, Closure closure) {
        NullCheck.notNull((Object)title, (String)"title");
        NullCheck.notNull((Object)closure, (String)"closure");
        ButtonDelegate d = new ButtonDelegate();
        closure.setDelegate((Object)d);
        this.frame.addClickable(title, values -> {
            closure.call((Object)values);
            return true;
        });
    }

    public final class ButtonDelegate {
        public void show(String id) {
            NullCheck.notEmpty((Object)id, (String)"id");
            WizardArea.Frame f = FrameDelegate.this.controller.frames.get(id);
            if (f == null) {
                throw new IllegalArgumentException("No such frame: " + id);
            }
            FrameDelegate.this.controller.area.show(f);
        }

        public void error(String message) {
            NullCheck.notNull((Object)message, (String)"message");
            FrameDelegate.this.controller.luwrain.message(message, Luwrain.MessageType.ERROR);
        }
    }
}

