/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaWrapperFactory;
import org.luwrain.core.Base;
import org.luwrain.core.LaunchedApp;
import org.luwrain.core.LaunchedAppPopups;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OpenedArea;
import org.luwrain.core.OpenedPopup;
import org.luwrain.core.Popup;
import org.luwrain.core.events.SystemEvent;

final class AppManager {
    private static final String LOG_COMPONENT = "core";
    private LaunchedApp desktopApp = null;
    private final ArrayList<LaunchedApp> apps = new ArrayList();
    private int activeAppIndex = -1;
    private final LaunchedAppPopups shell = new LaunchedAppPopups();
    private final List<OpenedPopup> popups = new ArrayList<OpenedPopup>();

    AppManager() {
    }

    void setDesktopApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        LaunchedApp newApp = new LaunchedApp(app);
        if (!newApp.init()) {
            throw new IllegalStateException("Unable to initialize the desktop app");
        }
        this.desktopApp = newApp;
    }

    List<Application> getLaunchedApps() {
        ArrayList<Application> res = new ArrayList<Application>();
        for (LaunchedApp a : this.apps) {
            res.add(a.app);
        }
        return res;
    }

    boolean setActiveApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        int index = this.findApp(app);
        if (index < 0) {
            return false;
        }
        this.activeAppIndex = index;
        return true;
    }

    boolean isActiveApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        if (this.isDesktopApp(app) && this.activeAppIndex < 0) {
            return true;
        }
        if (this.activeAppIndex < 0) {
            return false;
        }
        return this.apps.get((int)this.activeAppIndex).app == app;
    }

    Application getActiveApp() {
        if (this.activeAppIndex < 0) {
            return this.hasDesktopApp() ? this.desktopApp.app : null;
        }
        return this.apps.get((int)this.activeAppIndex).app;
    }

    boolean newApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        Application activeNow = this.activeAppIndex >= 0 ? this.apps.get((int)this.activeAppIndex).app : null;
        int index = this.findApp(app);
        if (index >= 0) {
            this.activeAppIndex = index;
            return true;
        }
        LaunchedApp launchedApp = new LaunchedApp(app);
        if (!launchedApp.init()) {
            return false;
        }
        launchedApp.activeAppBeforeLaunch = activeNow;
        this.apps.add(launchedApp);
        this.activeAppIndex = this.apps.size() - 1;
        return true;
    }

    void removeApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        int index = this.findApp(app);
        if (index == -1) {
            throw new IllegalArgumentException("Trying to remove an unknown app of class " + app.getClass().getName());
        }
        LaunchedApp removedApp = this.apps.get(index);
        this.apps.remove(index);
        for (LaunchedApp a : this.apps) {
            if (a.activeAppBeforeLaunch != app) continue;
            a.activeAppBeforeLaunch = null;
        }
        if (this.apps.isEmpty()) {
            this.activeAppIndex = -1;
            return;
        }
        if (removedApp.activeAppBeforeLaunch == null) {
            this.activeAppIndex = this.apps.size() - 1;
            return;
        }
        this.activeAppIndex = this.findApp(removedApp.activeAppBeforeLaunch);
        if (this.activeAppIndex < 0) {
            this.activeAppIndex = this.apps.size() - 1;
        }
    }

    void switchNextApp() {
        if (this.apps.isEmpty()) {
            this.activeAppIndex = -1;
            return;
        }
        if (this.activeAppIndex < 0) {
            this.desktopApp.removeReviewWrappers();
            this.activeAppIndex = 0;
            return;
        }
        this.apps.get(this.activeAppIndex).removeReviewWrappers();
        ++this.activeAppIndex;
        if (this.activeAppIndex >= this.apps.size()) {
            this.activeAppIndex = 0;
        }
    }

    boolean updateAppAreaLayout(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        if (this.isDesktopApp(app)) {
            return this.desktopApp.refreshAreaLayout();
        }
        int index = this.findApp(app);
        if (index < 0) {
            return false;
        }
        return this.apps.get(index).refreshAreaLayout();
    }

    boolean setActiveAreaForApp(Application app, Area area) {
        NullCheck.notNull((Object)app, (String)"app");
        NullCheck.notNull((Object)area, (String)"area");
        if (this.isDesktopApp(app)) {
            return this.desktopApp.setActiveArea(area);
        }
        int index = this.findApp(app);
        if (index < 0) {
            return false;
        }
        return this.apps.get(index).setActiveArea(area);
    }

    Area getFrontActiveAreaForActiveApp() {
        if (this.activeAppIndex < 0 && this.hasDesktopApp()) {
            return this.desktopApp.getFrontActiveArea();
        }
        if (this.activeAppIndex >= 0) {
            return this.apps.get(this.activeAppIndex).getFrontActiveArea();
        }
        return null;
    }

    void addNewPopup(Application app, Area area, Popup.Position position, Base.PopupStopCondition stopCondition, Set<Popup.Flags> flags) {
        LaunchedAppPopups launchedApp;
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)((Object)position), (String)"position");
        NullCheck.notNull((Object)stopCondition, (String)"stopCondition");
        if (app != null) {
            if (this.isDesktopApp(app)) {
                launchedApp = this.desktopApp;
            } else {
                int index = this.findApp(app);
                if (index < 0) {
                    return;
                }
                launchedApp = this.apps.get(index);
            }
        } else {
            launchedApp = this.shell;
        }
        int popupIndex = launchedApp.addPopup(area);
        this.popups.add(new OpenedPopup(app, popupIndex, position, stopCondition, flags));
    }

    void closeLastPopup() {
        if (this.popups.isEmpty()) {
            Base.warn("trying to remove the last popup without any opened popups at all");
            return;
        }
        OpenedPopup removedPopup = this.popups.get(this.popups.size() - 1);
        this.popups.remove(this.popups.size() - 1);
        if (removedPopup.app != null) {
            if (this.isDesktopApp(removedPopup.app)) {
                this.desktopApp.closeLastPopup();
            } else {
                int appIndex = this.findApp(removedPopup.app);
                if (appIndex >= 0) {
                    this.apps.get(appIndex).closeLastPopup();
                } else {
                    Base.warn("the popup being closed is associated with unknown application");
                }
            }
        } else {
            this.shell.closeLastPopup();
        }
    }

    boolean isLastPopupDiscontinued() {
        if (this.popups.isEmpty()) {
            return true;
        }
        return !this.popups.get((int)(this.popups.size() - 1)).stopCondition.continueEventLoop();
    }

    boolean hasAnyPopup() {
        return !this.popups.isEmpty();
    }

    boolean hasPopupOfApp(Application app) {
        LaunchedAppPopups launchedApp;
        if (app != null) {
            if (this.isDesktopApp(app)) {
                launchedApp = this.desktopApp;
            } else {
                int index = this.findApp(app);
                if (index < 0) {
                    return false;
                }
                launchedApp = this.apps.get(index);
            }
        } else {
            launchedApp = this.shell;
        }
        return launchedApp.popupWrappings.size() > 0;
    }

    Application getAppOfLastPopup() {
        return !this.popups.isEmpty() ? this.popups.get((int)(this.popups.size() - 1)).app : null;
    }

    Area getFrontAreaOfTopPopup() {
        LaunchedAppPopups launchedApp;
        if (this.popups.isEmpty()) {
            return null;
        }
        OpenedPopup popup = this.popups.get(this.popups.size() - 1);
        if (popup.app != null) {
            if (this.isDesktopApp(popup.app)) {
                launchedApp = this.desktopApp;
            } else {
                int appIndex = this.findApp(popup.app);
                if (appIndex < 0) {
                    Base.warn("The top popup is associated with unknown app");
                    return null;
                }
                launchedApp = this.apps.get(appIndex);
            }
        } else {
            launchedApp = this.shell;
        }
        return launchedApp.getFrontAreaOfPopup(popup.index);
    }

    AreaLayout getFrontAreaLayout(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        if (this.isDesktopApp(app)) {
            return this.desktopApp.getFrontAreaLayout();
        }
        int index = this.findApp(app);
        if (index < 0) {
            return null;
        }
        return this.apps.get(index).getFrontAreaLayout();
    }

    boolean isAppLaunched(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        if (this.isDesktopApp(app)) {
            return true;
        }
        return this.findApp(app) >= 0;
    }

    Area getCorrespondingEffectiveArea(Application app, Area area) {
        NullCheck.notNull((Object)app, (String)"app");
        NullCheck.notNull((Object)area, (String)"area");
        if (this.isDesktopApp(app)) {
            return this.desktopApp.getCorrespondingFrontArea(area);
        }
        int index = this.findApp(app);
        if (index < 0) {
            return null;
        }
        return this.apps.get(index).getCorrespondingFrontArea(area);
    }

    Area getCorrespondingEffectiveArea(Area area) {
        Object res;
        NullCheck.notNull((Object)area, (String)"area");
        if (this.hasDesktopApp() && (res = this.desktopApp.getCorrespondingFrontArea(area)) != null) {
            return res;
        }
        for (LaunchedApp a : this.apps) {
            Area res2 = a.getCorrespondingFrontArea(area);
            if (res2 == null) continue;
            return res2;
        }
        res = this.shell.getCorrespondingFrontArea(area);
        if (res != null) {
            return res;
        }
        return null;
    }

    OpenedArea getAreaWrapping(Area area) {
        Object res;
        NullCheck.notNull((Object)area, (String)"area");
        if (this.hasDesktopApp() && (res = this.desktopApp.getAreaWrapping(area)) != null) {
            return res;
        }
        for (LaunchedApp a : this.apps) {
            OpenedArea res2 = a.getAreaWrapping(area);
            if (res2 == null) continue;
            return res2;
        }
        res = this.shell.getAreaWrapping(area);
        if (res != null) {
            return res;
        }
        return null;
    }

    boolean setAreaWrapper(Area area, AreaWrapperFactory factory) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)factory, (String)"factory");
        OpenedArea wrapping = this.getAreaWrapping(area);
        if (wrapping == null || wrapping.wrapper != null) {
            return false;
        }
        Area wrapper = factory.createAreaWrapper(area, wrapping);
        if (wrapper == null) {
            return false;
        }
        wrapping.wrapper = wrapper;
        return true;
    }

    Popup.Position getPositionOfTopPopup() {
        if (this.popups.isEmpty()) {
            return null;
        }
        return this.popups.get((int)(this.popups.size() - 1)).position;
    }

    void onNewPopupOpening(Application app, Class newCopyClass) {
        if (this.isDesktopApp(app)) {
            return;
        }
        for (OpenedPopup p : this.popups) {
            Area area;
            if (p.app != app || !p.flags.contains((Object)Popup.Flags.NO_MULTIPLE_COPIES)) continue;
            if (app != null) {
                int index = this.findApp(app);
                if (index < 0) {
                    Base.error("popups contains a reference to the unregistered application " + app.getClass().getName());
                    continue;
                }
                area = this.apps.get(index).getNativeAreaOfPopup(p.index);
            } else {
                area = this.shell.getNativeAreaOfPopup(p.index);
            }
            if (area == null) {
                Base.error("unable to find a native area of the popup with index " + p.index + " of " + (String)(app != null ? " the application " + app.getClass().getName() : " the environment"));
                continue;
            }
            if (!area.getClass().equals(newCopyClass)) continue;
            p.stopCondition.cancel();
        }
    }

    void sendBroadcastEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        for (LaunchedApp a : this.apps) {
            a.sendBroadcastEvent(event);
        }
    }

    private int findApp(Application app) {
        for (int i = 0; i < this.apps.size(); ++i) {
            if (this.apps.get((int)i).app != app) continue;
            return i;
        }
        return -1;
    }

    private boolean isDesktopApp(Application app) {
        if (app == null || this.desktopApp == null) {
            return false;
        }
        return app == this.desktopApp.app;
    }

    private boolean hasDesktopApp() {
        return this.desktopApp != null;
    }
}

