/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public final class AreaLayoutSwitch {
    private Luwrain luwrain;
    private final ArrayList<AreaLayout> layouts = new ArrayList();
    private int currentIndex = 0;

    public AreaLayoutSwitch(Luwrain luwrain) {
        this.luwrain = luwrain;
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void add(AreaLayout layout) {
        NullCheck.notNull((Object)layout, (String)"layout");
        this.layouts.add(layout);
    }

    public boolean show(int index) {
        if (index < 0 || index >= this.layouts.size()) {
            return false;
        }
        this.currentIndex = index;
        this.luwrain.onNewAreaLayout();
        return true;
    }

    public AreaLayout getCurrentLayout() {
        if (this.currentIndex >= this.layouts.size()) {
            return null;
        }
        return this.layouts.get(this.currentIndex);
    }
}

