/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.AppManager;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Base;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.Config;
import org.luwrain.core.Luwrain;
import org.luwrain.core.TilesManager;
import org.luwrain.core.WindowManager;
import org.luwrain.core.queries.BackgroundSoundQuery;

abstract class Areas
extends Base {
    protected final AppManager apps = new AppManager();
    protected final TilesManager tiles = new TilesManager(this.apps);
    protected final WindowManager windowManager;

    protected Areas(Config conf) {
        super(conf);
        this.windowManager = new WindowManager(conf.getInteraction(), this.tiles);
    }

    void onNewAreasLayout() {
        this.tiles.updatePopupState();
        this.windowManager.redraw();
        this.updateBackgroundSound(null);
    }

    protected void updateBackgroundSound(Area updateFor) {
        Area area = this.tiles.getActiveArea();
        if (updateFor != null && area != updateFor) {
            return;
        }
        if (area != null) {
            BackgroundSoundQuery query = new BackgroundSoundQuery();
            if (AreaQuery.ask(area, query)) {
                BackgroundSoundQuery.Answer answer = query.getAnswer();
                if (answer.isUrl()) {
                    this.soundManager.playBackground(answer.getUrl());
                } else {
                    this.soundManager.playBackground(answer.getBkgSound());
                }
                return;
            }
            if (updateFor != null) {
                this.soundManager.stopBackground();
                return;
            }
        }
        if (this.tiles.isPopupActive()) {
            this.soundManager.playBackground(BkgSounds.POPUP);
        } else {
            this.soundManager.stopBackground();
        }
    }

    Area getFrontAreaFor(Luwrain instance, Area area) {
        Application app;
        Area effectiveArea = null;
        if (instance != null && (app = this.interfaces.findApp(instance)) != null && this.apps.isAppLaunched(app)) {
            effectiveArea = this.apps.getCorrespondingEffectiveArea(app, area);
        }
        if (effectiveArea == null) {
            effectiveArea = this.apps.getCorrespondingEffectiveArea(area);
        }
        return effectiveArea;
    }
}

