/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Braille;
import org.luwrain.core.EventConsumer;
import org.luwrain.core.InitResult;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.core.Settings;

public final class BrailleImpl {
    private Registry registry;
    private Braille braille;
    private boolean active = false;
    private String errorMessage = "";

    void init(Registry registry, Braille braille, EventConsumer eventConsumer) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notNull((Object)eventConsumer, (String)"eventConsumer");
        this.braille = braille;
        if (braille == null) {
            this.active = false;
            this.errorMessage = "No braille support in the operating system";
            return;
        }
        Settings.Braille settings = Settings.createBraille(registry);
        if (!settings.getEnabled(false)) {
            return;
        }
        InitResult res = braille.init(eventConsumer);
        if (res.isOk()) {
            this.active = true;
            this.errorMessage = "";
        } else {
            this.active = false;
            this.errorMessage = res.toString();
        }
    }

    void textToSpeak(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        if (this.braille == null) {
            return;
        }
        this.braille.writeText(text);
    }

    public boolean isActive() {
        return this.active;
    }

    public String getDriver() {
        return this.braille != null ? this.braille.getDriverName() : "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getDisplayWidth() {
        return this.braille != null ? this.braille.getDisplayWidth() : 0;
    }

    public int getDisplayHeight() {
        return this.braille != null ? this.braille.getDisplayHeight() : 0;
    }
}

