/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luwrain.core.Job;
import org.luwrain.core.NullCheck;

public class EmptyJob
implements Job {
    protected final Job.Listener listener;
    protected final String name;
    protected Map<String, List<String>> info = new HashMap<String, List<String>>();
    private Job.Status status = Job.Status.RUNNING;
    private int exitCode = -1;

    public EmptyJob(Job.Listener listener, String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        this.listener = listener;
        this.name = name;
    }

    public EmptyJob(String name) {
        this(null, name);
    }

    @Override
    public String getInstanceName() {
        return this.name;
    }

    @Override
    public Job.Status getStatus() {
        return this.status;
    }

    @Override
    public int getExitCode() {
        if (this.status != Job.Status.FINISHED) {
            throw new IllegalStateException("The job '" + this.name + "' is still running");
        }
        return this.exitCode;
    }

    @Override
    public boolean isFinishedSuccessfully() {
        return this.status == Job.Status.FINISHED && this.exitCode == 0;
    }

    public void setInfo(String infoType, List<String> value) {
        NullCheck.notEmpty((Object)infoType, (String)"infoType");
        NullCheck.notNull(value, (String)"value");
        if (this.status != Job.Status.RUNNING) {
            throw new IllegalStateException("The job '" + this.name + "' is not running");
        }
        this.info.put(infoType, value);
        if (this.listener != null) {
            this.listener.onInfoChange(this, infoType, value);
        }
    }

    @Override
    public List<String> getInfo(String infoType) {
        NullCheck.notEmpty((Object)infoType, (String)"infoType");
        List<String> res = this.info.get(infoType);
        return res != null ? res : Arrays.asList(new String[0]);
    }

    public void stop(int exitCode) {
        if (this.status != Job.Status.RUNNING) {
            throw new IllegalStateException("The job '" + this.name + "' is not running");
        }
        this.status = Job.Status.FINISHED;
        this.exitCode = exitCode;
        if (this.listener != null) {
            this.listener.onStatusChange(this);
        }
    }

    @Override
    public void stop() {
    }
}

