/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Configs;
import org.luwrain.core.Core;
import org.luwrain.core.NullCheck;
import org.luwrain.io.json.FileType;

final class FileTypes {
    private static final Logger log = LogManager.getLogger();
    private static final String JOB_PREFIX = "job:";
    private final Map<String, FileType> fileTypes = new HashMap<String, FileType>();

    FileTypes() {
    }

    void load(Configs configs) {
        Objects.requireNonNull(configs, "configs");
        this.fileTypes.clear();
        org.luwrain.io.json.FileTypes conf = configs.load(org.luwrain.io.json.FileTypes.class);
        if (conf != null && conf.getTypes() != null) {
            this.fileTypes.putAll(conf.getTypes());
        }
    }

    void launch(Core core, String[] files) {
        Objects.requireNonNull(core, "core can't be null");
        Objects.requireNonNull(files, "files can't be null");
        String[] shortcuts = this.selectShortcuts(files);
        HashMap lists = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            String s = shortcuts[i];
            String f = files[i];
            if (s.isEmpty()) continue;
            if (lists.containsKey(s)) {
                ((List)lists.get(s)).add(f);
                continue;
            }
            ArrayList<String> l = new ArrayList<String>();
            l.add(f);
            lists.put(s, l);
        }
        for (Map.Entry e : lists.entrySet()) {
            String[] toOpen;
            if (this.runJob(core, (String)e.getKey(), (List)e.getValue())) continue;
            String shortcut = (String)e.getKey();
            boolean takesMultiple = false;
            boolean takesUrls = false;
            for (String f : toOpen = ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()])) {
                core.launchApp(shortcut, new String[]{f});
            }
        }
    }

    private boolean runJob(Core core, String exp, List<String> args) {
        return true;
    }

    private String[] selectShortcuts(String[] fileNames) {
        NullCheck.notEmptyItems((Object[])fileNames, (String)"fileNames");
        LinkedList<String> res = new LinkedList<String>();
        for (String s : fileNames) {
            if (s.isEmpty()) {
                res.add("");
                continue;
            }
            Path path = Paths.get(s, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                res.add("notepad");
                continue;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                res.add("commander");
                continue;
            }
            String ext = this.getExt(s).trim().toLowerCase();
            if (ext.trim().isEmpty() || !this.fileTypes.containsKey(ext)) {
                res.add("notepad");
                continue;
            }
            FileType fileType = this.fileTypes.get(ext);
            res.add(fileType != null ? fileType.getName() : "notepad");
        }
        return res.toArray(new String[res.size()]);
    }

    private String getExt(String fileName) {
        Objects.requireNonNull(fileName, "fileName can't be null");
        String name = new File(fileName).getName();
        if (name.isEmpty()) {
            return "";
        }
        int dotPos = name.lastIndexOf(".");
        if (dotPos < 1 || dotPos + 1 >= name.length()) {
            return "";
        }
        return name.substring(dotPos + 1);
    }

    private String getExtension(URL url) {
        Objects.requireNonNull(url, "url can't be null");
        String name = url.getFile();
        if (name.isEmpty()) {
            return "";
        }
        int dotPos = name.lastIndexOf(".");
        if (dotPos < 1 || dotPos + 1 >= name.length()) {
            return "";
        }
        return name.substring(dotPos + 1);
    }
}

