/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Extension;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesProvider;
import org.luwrain.core.Shortcut;
import org.luwrain.core.Worker;

final class ObjRegistry {
    private static final Logger log = LogManager.getLogger();
    private Map<String, Entry<Shortcut>> shortcuts = new HashMap<String, Entry<Shortcut>>();
    private Map<String, Entry<Worker>> workers = new HashMap<String, Entry<Worker>>();
    private Map<String, Entry<PropertiesProvider>> propsProviders = new HashMap<String, Entry<PropertiesProvider>>();

    ObjRegistry() {
    }

    boolean add(Extension ext, ExtensionObject obj) {
        NullCheck.notNull((Object)obj, (String)"obj");
        String name = obj.getExtObjName();
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        boolean res = false;
        if (obj instanceof Shortcut) {
            Shortcut shortcut = (Shortcut)obj;
            if (!this.shortcuts.containsKey(name)) {
                this.shortcuts.put(name, new Entry<Shortcut>(ext, name, shortcut));
                res = true;
            }
        }
        if (obj instanceof Worker) {
            Worker worker = (Worker)obj;
            if (!this.workers.containsKey(name)) {
                this.workers.put(name, new Entry<Worker>(ext, name, worker));
                res = true;
            }
        }
        if (obj instanceof PropertiesProvider) {
            PropertiesProvider provider = (PropertiesProvider)obj;
            if (!this.propsProviders.containsKey(name)) {
                this.propsProviders.put(name, new Entry<PropertiesProvider>(ext, name, provider));
                res = true;
            }
        }
        if (!res) {
            log.warn("Failed to add an extension object of class " + obj.getClass().getName() + " with name '" + name + "'");
        }
        return res;
    }

    void deleteByExt(Extension ext) {
        NullCheck.notNull((Object)ext, (String)"ext");
        ObjRegistry.removeEntriesByExt(this.shortcuts, ext);
        ObjRegistry.removeEntriesByExt(this.workers, ext);
    }

    Shortcut getShortcut(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        if (!this.shortcuts.containsKey(name)) {
            return null;
        }
        return (Shortcut)this.shortcuts.get((Object)name).obj;
    }

    String[] getShortcutNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Entry<Shortcut>> e : this.shortcuts.entrySet()) {
            res.add(e.getKey());
        }
        Object[] str = res.toArray(new String[res.size()]);
        Arrays.sort(str);
        return str;
    }

    Worker[] getWorkers() {
        ArrayList<Worker> res = new ArrayList<Worker>();
        for (Map.Entry<String, Entry<Worker>> e : this.workers.entrySet()) {
            res.add((Worker)e.getValue().obj);
        }
        return res.toArray(new Worker[res.size()]);
    }

    PropertiesProvider[] getPropertiesProviders() {
        ArrayList<PropertiesProvider> res = new ArrayList<PropertiesProvider>();
        for (Map.Entry<String, Entry<PropertiesProvider>> e : this.propsProviders.entrySet()) {
            res.add((PropertiesProvider)e.getValue().obj);
        }
        return res.toArray(new PropertiesProvider[res.size()]);
    }

    static void issueResultingMessage(Luwrain luwrain, int exitCode, String[] lines) {
        String text;
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        StringBuilder b = new StringBuilder();
        if (lines.length >= 1) {
            b.append(lines[0]);
            for (int i = 1; i < lines.length; ++i) {
                b.append(" " + lines[i]);
            }
        }
        if (!(text = new String(b).trim()).isEmpty()) {
            luwrain.message(text, exitCode == 0 ? Luwrain.MessageType.DONE : Luwrain.MessageType.ERROR);
        } else if (exitCode == 0) {
            luwrain.message(luwrain.i18n().getStaticStr("OsCommandFinishedSuccessfully"), Luwrain.MessageType.DONE);
        } else {
            luwrain.message(luwrain.i18n().getStaticStr("OsCommandFailed"), Luwrain.MessageType.ERROR);
        }
    }

    void takeObjects(Extension ext, ExtensionObject[] extObjects) {
        NullCheck.notNullItems((Object[])extObjects, (String)"extObjects");
        for (ExtensionObject obj : extObjects) {
            if (this.add(ext, obj)) continue;
            log.warn("The extension object '" + obj.getExtObjName() + "' of the extension " + ext.getClass().getName() + " has been refused by  the object registry");
        }
    }

    private static <E> void removeEntriesByExt(Map<String, Entry<E>> map, Extension ext) {
        Objects.requireNonNull(map, "map can't be null");
        Objects.requireNonNull(ext, "ext can't be null");
        ArrayList<String> deleting = new ArrayList<String>();
        for (Map.Entry<String, Entry<E>> e : map.entrySet()) {
            if (e.getValue().ext != ext) continue;
            deleting.add(e.getKey());
        }
        for (String s : deleting) {
            map.remove(s);
        }
    }

    private static final class Entry<E> {
        final Extension ext;
        final String name;
        final E obj;

        Entry(Extension ext, String name, E obj) {
            NullCheck.notEmpty((Object)name, (String)"name");
            NullCheck.notNull(obj, (String)"obj");
            this.ext = ext;
            this.name = name;
            this.obj = obj;
        }
    }
}

