/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.NullCheck;

public interface Registry {
    public static final int INVALID = 0;
    public static final int INTEGER = 1;
    public static final int STRING = 2;
    public static final int BOOLEAN = 3;

    public boolean addDirectory(String var1);

    public boolean deleteDirectory(String var1);

    public boolean deleteValue(String var1);

    public boolean getBoolean(String var1);

    public String[] getDirectories(String var1);

    public int getInteger(String var1);

    public String getString(String var1);

    public String getStringDesignationOfType(int var1);

    public int getTypeOf(String var1);

    public String[] getValues(String var1);

    public boolean hasDirectory(String var1);

    public boolean hasValue(String var1);

    public boolean setBoolean(String var1, boolean var2);

    public boolean setInteger(String var1, int var2);

    public boolean setString(String var1, String var2);

    public static String join(String part1, String part2) {
        NullCheck.notNull((Object)part1, (String)"part1");
        NullCheck.notNull((Object)part2, (String)"part2");
        if (part1.isEmpty()) {
            throw new IllegalArgumentException("part1 may not be empty");
        }
        if (part2.isEmpty()) {
            throw new IllegalArgumentException("part2 may not be empty");
        }
        if (part2.charAt(0) == '/') {
            throw new IllegalArgumentException("part2 may not begin with a slash");
        }
        if (part1.endsWith("/")) {
            return part1 + part2;
        }
        return part1 + "/" + part2;
    }

    public static int nextFreeNum(Registry registry, String path) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notNull((Object)path, (String)"path");
        String[] values = registry.getDirectories(path);
        int res = 0;
        for (String s : values) {
            if (s.isEmpty()) continue;
            int value = 0;
            try {
                value = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                continue;
            }
            if (value <= res) continue;
            res = value;
        }
        return res + 1;
    }
}

