/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.AreaWrapperFactory;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.Core;
import org.luwrain.core.Luwrain;
import org.luwrain.core.LuwrainImpl;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.MoveHotPointEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

public class Search
implements Area {
    private final Area area;
    private final Core core;
    private final AreaWrapperFactory.Disabling disabling;
    private int hotPointX = 0;
    private int hotPointY = 0;
    private String expression = "";

    public Search(Area area, Core core, AreaWrapperFactory.Disabling disabling) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)core, (String)"core");
        NullCheck.notNull((Object)disabling, (String)"disabling");
        this.area = area;
        this.core = core;
        this.disabling = disabling;
        this.hotPointX = area.getHotPointX();
        this.hotPointY = area.getHotPointY();
        if (this.hotPointX < 0) {
            this.hotPointX = 0;
        }
        if (this.hotPointY < 0) {
            this.hotPointY = 0;
        }
        core.message(core.i18n.getStaticStr("SearchMode"), Luwrain.MessageType.NONE);
        core.soundManager.playIcon(Sounds.SEARCH);
    }

    @Override
    public String getAreaName() {
        return "\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u0438\u0441\u043a\u0430: " + this.area.getAreaName();
    }

    @Override
    public int getHotPointX() {
        return this.hotPointX + this.expression.length();
    }

    @Override
    public int getHotPointY() {
        return this.hotPointY;
    }

    @Override
    public int getLineCount() {
        return this.area.getLineCount();
    }

    @Override
    public String getLine(int index) {
        return this.area.getLine(index);
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case TAB: {
                    return this.onNewChar('\u0000');
                }
                case ESCAPE: {
                    this.closeSearch(false);
                    return true;
                }
                case ENTER: {
                    return this.closeSearch(true);
                }
                case ARROW_LEFT: 
                case ARROW_RIGHT: 
                case ARROW_UP: 
                case ARROW_DOWN: {
                    return this.announceCurrentLine();
                }
            }
            return false;
        }
        return this.onNewChar(event.getChar());
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        return this.area.onSystemEvent(event);
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.SEARCH));
                return true;
            }
        }
        return this.area.onAreaQuery(query);
    }

    private boolean onNewChar(char c) {
        String lookFor;
        String string = lookFor = c != '\u0000' ? this.expression + Character.toLowerCase(c) : this.expression;
        if (c == '\u0000') {
            if (this.expression.isEmpty()) {
                return false;
            }
            ++this.hotPointX;
        }
        if (this.hotPointY > this.getLineCount()) {
            this.core.soundManager.playIcon(Sounds.BLOCKED);
            return true;
        }
        String line = this.getLine(this.hotPointY);
        if (line != null && this.hotPointX < line.length()) {
            line = line.toLowerCase();
            int pos = (line = line.substring(this.hotPointX)).indexOf(lookFor);
            if (pos >= 0) {
                this.hotPointX += pos;
                this.expression = lookFor;
                this.core.windowManager.redraw();
                this.core.message(this.getLine(this.hotPointY), Luwrain.MessageType.NONE);
                return true;
            }
        }
        for (int i = this.hotPointY + 1; i < this.getLineCount(); ++i) {
            int pos;
            line = this.getLine(i);
            if (line == null || (pos = (line = line.toLowerCase()).indexOf(lookFor)) < 0) continue;
            this.hotPointX = pos;
            this.hotPointY = i;
            this.core.message(line, Luwrain.MessageType.NONE);
            this.expression = lookFor;
            this.core.windowManager.redraw();
            return true;
        }
        this.core.soundManager.playIcon(Sounds.BLOCKED);
        return true;
    }

    private boolean closeSearch(boolean accept) {
        if (accept) {
            if (!this.area.onSystemEvent(new MoveHotPointEvent(this.hotPointX, this.hotPointY, false))) {
                return false;
            }
            this.core.setAreaIntroduction();
        } else {
            this.core.message("\u041f\u043e\u0438\u0441\u043a \u043e\u0442\u043c\u0435\u043d\u0451\u043d", Luwrain.MessageType.NONE);
        }
        this.core.soundManager.playIcon(Sounds.CANCEL);
        this.disabling.disableAreaWrapper();
        this.core.onNewAreasLayout();
        return true;
    }

    private boolean announceCurrentLine() {
        if (this.hotPointY >= this.area.getLineCount()) {
            return false;
        }
        String line = this.area.getLine(this.hotPointY);
        if (line == null) {
            return false;
        }
        new LuwrainImpl(this.core).speak(line);
        return true;
    }
}

