/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Args;
import org.luwrain.core.Configs;
import org.luwrain.core.ExtensionsManager;
import org.luwrain.core.NullCheck;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Engine;

public final class Speech {
    private static final Logger log = LogManager.getLogger();
    public static final int PITCH_HINT = -25;
    static final int PITCH_MESSAGE = -25;
    private static final String SPEECH_PREFIX = "--speech=";
    private final Args args;
    private final Configs configs;
    private final ExtensionsManager extensions;
    private final Map<String, Engine> engines = new HashMap<String, Engine>();
    private Channel defaultChannel = null;
    private int pitch = 50;
    private int rate = 50;

    Speech(Args args, Configs configs, ExtensionsManager extensions) {
        this.args = Objects.requireNonNull(args, "args can't be null");
        this.configs = Objects.requireNonNull(configs, "configs can't be null");
        this.extensions = Objects.requireNonNull(extensions);
        this.pitch = 50;
        this.rate = 50;
    }

    void init() {
        List<Engine> engines = this.extensions.load(Engine.class);
        for (Engine e : engines) {
            String name = e.getExtObjName();
            if (name == null || name.isEmpty()) {
                log.warn("A speech engine with empty name found, skipping it");
                continue;
            }
            if (this.engines.containsKey(name)) {
                log.warn("Two speech engines with the same name '" + name + "'");
                continue;
            }
            this.engines.put(name, e);
            log.trace("Registered the speech engine '" + name + "'");
        }
        if (engines.isEmpty()) {
            log.warn("No speech engines, skipping speech output initialization");
            this.defaultChannel = null;
            return;
        }
        String engineName = null;
        Map<String, String> params = null;
        Config conf = this.configs.load(Config.class);
        if (this.args.speech != null && !this.args.speech.isEmpty()) {
            engineName = this.args.speech;
            params = this.parseParams(Objects.requireNonNullElse(this.args.speechParams, new ArrayList()));
        } else if (conf != null && !Objects.requireNonNullElse(conf.engineName, "").isEmpty()) {
            engineName = conf.engineName;
            params = conf.params;
        }
        if (engineName == null || engineName.isEmpty()) {
            engineName = this.args.defSpeech;
            params = this.parseParams(Objects.requireNonNullElse(this.args.defSpeechParams, new ArrayList()));
        }
        if (engineName == null || engineName.isEmpty()) {
            log.warn("Speech engine not specified. Use the '--speech' or '--def-spech' command line options to set the desired engine name");
            this.defaultChannel = null;
            return;
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        log.trace("Loading speech engine '" + engineName + "' with params " + params.toString());
        this.defaultChannel = this.loadChannel(engineName, params);
        if (this.defaultChannel != null) {
            log.trace("Main speech engine is '" + engineName + "'");
        } else {
            log.error("Unable to load the default channel of the engine '" + engineName + "'");
        }
    }

    private Map<String, String> parseParams(List<String> values) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (values.isEmpty()) {
            return params;
        }
        for (String p : values) {
            int eq = p.indexOf("=");
            if (eq > 0) {
                params.put(p.substring(0, eq), p.substring(eq + 1));
                continue;
            }
            params.put(p, "");
        }
        return params;
    }

    public Channel loadChannel(String engineName, String paramsLine) {
        return null;
    }

    private Channel loadChannel(String engineName, Map<String, String> params) {
        Objects.requireNonNull(engineName, "engineName");
        Objects.requireNonNull(params, "params");
        if (engineName.isEmpty()) {
            throw new IllegalArgumentException("engineName can't be empty");
        }
        if (!this.engines.containsKey(engineName)) {
            log.error("No such speech engine: '" + engineName + "'");
            return null;
        }
        return this.engines.get(engineName).newChannel(params);
    }

    public void speak(String text, int relPitch, int relRate) {
        NullCheck.notNull((Object)text, (String)"text");
        if (this.defaultChannel == null || text.isEmpty()) {
            return;
        }
        this.defaultChannel.speak(text, null, this.makePitch(relPitch), this.makeRate(relRate), true);
    }

    public void speakEventResponse(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        if (this.defaultChannel == null || text.isEmpty()) {
            return;
        }
        this.defaultChannel.speak(text, null, this.makePitch(0), this.makeRate(0), true);
    }

    public void speakLetter(char letter, int relPitch, int relRate) {
        if (this.defaultChannel == null) {
            return;
        }
        this.defaultChannel.speakLetter(letter, null, this.makePitch(relPitch), this.makeRate(relRate), true);
    }

    void silence() {
        if (this.defaultChannel == null) {
            return;
        }
        this.defaultChannel.silence();
    }

    int getRate() {
        return this.rate;
    }

    void setRate(int value) {
        this.rate = value < 0 ? 0 : (value > 100 ? 100 : value);
    }

    int getPitch() {
        return this.pitch;
    }

    void setPitch(int value) {
        this.pitch = value < 0 ? 0 : (value > 100 ? 100 : value);
    }

    private int makePitch(int relPitch) {
        int value = this.pitch + relPitch - 50;
        if (value < -50) {
            return -50;
        }
        if (value > 50) {
            return 50;
        }
        return value;
    }

    private int makeRate(int relRate) {
        int value = this.rate + relRate - 50;
        if (value < -50) {
            return -50;
        }
        if (value > 50) {
            return 50;
        }
        return value;
    }

    private static final class Config {
        String engineName;
        Map<String, String> params;

        private Config() {
        }
    }
}

