/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.ContentTypes;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MediaResourcePlayer;
import org.luwrain.core.NullCheck;
import org.luwrain.util.SoundUtils;

public final class WavePlayers {
    private static final Logger log = LogManager.getLogger();

    static class Player
    implements MediaResourcePlayer {
        Player() {
        }

        @Override
        public MediaResourcePlayer.Instance newMediaResourcePlayer(Luwrain luwrain, MediaResourcePlayer.Listener listener) {
            Objects.requireNonNull(listener, "listener can't be null");
            return new PlayerInstance(listener);
        }

        @Override
        public String getSupportedMimeType() {
            return ContentTypes.SOUND_WAVE_DEFAULT;
        }

        @Override
        public String getExtObjName() {
            return "wav";
        }
    }

    private static final class PlayerInstance
    implements MediaResourcePlayer.Instance {
        private final MediaResourcePlayer.Listener listener;
        private SourceDataLine line = null;
        private volatile boolean interruptPlayback = false;

        PlayerInstance(MediaResourcePlayer.Listener listener) {
            NullCheck.notNull((Object)listener, (String)"listener");
            this.listener = listener;
        }

        @Override
        public MediaResourcePlayer.Result play(URL url, MediaResourcePlayer.Params params) {
            AudioInputStream audioInputStream;
            NullCheck.notNull((Object)url, (String)"url");
            NullCheck.notNull((Object)params, (String)"params");
            NullCheck.notNull(params.flags, (String)"params.flags");
            if (params.playFromMsec < 0L) {
                throw new IllegalArgumentException("params.playFromMsec (" + params.playFromMsec + ") may not be negative");
            }
            if (params.volume < 0 || params.volume > 100) {
                throw new IllegalArgumentException("params.volume (" + params.volume + ") must be between 0 and 100 inclusively");
            }
            this.interruptPlayback = false;
            try {
                audioInputStream = AudioSystem.getAudioInputStream(url.openStream());
            }
            catch (IOException | UnsupportedAudioFileException ex) {
                log.error("Unable to play " + url.toString(), (Throwable)ex);
                return new MediaResourcePlayer.Result(MediaResourcePlayer.Result.Type.INACCESSIBLE_SOURCE);
            }
            AudioFormat format = audioInputStream.getFormat();
            new Thread(() -> {
                try {
                    try {
                        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                        this.line = (SourceDataLine)AudioSystem.getLine(info);
                        if (!SoundUtils.setLineMasterGanePercent(this.line, params.volume)) {
                            log.error("Unable to set the initial volume to " + params.volume);
                        }
                        this.line.open(format);
                        this.line.start();
                        long totalBytes = 0L;
                        if (params.playFromMsec > 0L) {
                            long skipBytes = PlayerInstance.mSecToBytes(format, params.playFromMsec);
                            audioInputStream.skip(skipBytes);
                            totalBytes += skipBytes;
                        }
                        long notifiedMsec = PlayerInstance.bytesToMsec(format, totalBytes);
                        int bytesRead = 0;
                        byte[] buf = new byte[512];
                        while (bytesRead != -1 && !this.interruptPlayback) {
                            long currentMsec;
                            bytesRead = audioInputStream.read(buf, 0, buf.length);
                            if (bytesRead > 0 && !this.interruptPlayback) {
                                this.line.write(buf, 0, bytesRead);
                            }
                            if ((currentMsec = PlayerInstance.bytesToMsec(format, totalBytes += (long)bytesRead)) <= notifiedMsec + 50L) continue;
                            notifiedMsec = currentMsec;
                            this.listener.onPlayerTime(this, currentMsec);
                        }
                        this.line.drain();
                        this.listener.onPlayerFinish(this);
                        return;
                    }
                    finally {
                        audioInputStream.close();
                        PlayerInstance playerInstance = this;
                        synchronized (playerInstance) {
                            if (this.line != null) {
                                this.line.close();
                            }
                            this.line = null;
                        }
                    }
                }
                catch (Exception ex) {
                    log.error("Unable to continue playing of " + url.toString(), (Throwable)ex);
                    this.listener.onPlayerError(ex);
                    return;
                }
            }).start();
            return new MediaResourcePlayer.Result();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            this.interruptPlayback = true;
            PlayerInstance playerInstance = this;
            synchronized (playerInstance) {
                if (this.line != null) {
                    this.line.stop();
                }
            }
        }

        @Override
        public void setVolume(int value) {
            if (value < 0 || value > 100) {
                throw new IllegalArgumentException("value (" + value + ") must be between 0 and 100 (inclusively)");
            }
            if (this.line == null) {
                return;
            }
            if (!SoundUtils.setLineMasterGanePercent(this.line, value)) {
                log.error("Unable to change the volume to " + value);
            }
        }

        private static long mSecToBytes(AudioFormat format, float msec) {
            Objects.requireNonNull(format, "format can't be null");
            return (long)(format.getSampleRate() * (float)format.getSampleSizeInBits() * msec / 8000.0f);
        }

        private static long bytesToMsec(AudioFormat format, long bytes) {
            Objects.requireNonNull(format, "format can't be null");
            float samples = 8.0f * (float)bytes / (float)format.getSampleSizeInBits();
            return (long)(1000.0f * samples / format.getSampleRate());
        }
    }

    public static class Simple
    implements Runnable {
        private final String fileName;
        private final InputStream inputStream;
        private final int volumePercent;
        private volatile boolean interruptPlayback = false;
        public boolean finished = false;
        private SourceDataLine audioLine = null;

        public Simple(String fileName, int volumePercent) {
            NullCheck.notEmpty((Object)fileName, (String)"fileName");
            this.fileName = fileName;
            this.inputStream = null;
            this.volumePercent = volumePercent;
        }

        public Simple(InputStream inputStream, int volumePercent) {
            NullCheck.notNull((Object)inputStream, (String)"inputStream");
            this.inputStream = inputStream;
            this.fileName = null;
            this.volumePercent = volumePercent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioInputStream audioInputStream = null;
            try {
                try {
                    if (this.inputStream == null) {
                        File soundFile = new File(this.fileName);
                        if (!soundFile.exists()) {
                            return;
                        }
                        audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                    } else {
                        audioInputStream = AudioSystem.getAudioInputStream(this.inputStream);
                    }
                    AudioFormat format = audioInputStream.getFormat();
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    this.audioLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.audioLine.open(format);
                    this.audioLine.start();
                    if (this.volumePercent >= 0 || this.volumePercent < 100) {
                        SoundUtils.setLineMasterGanePercent(this.audioLine, this.volumePercent);
                    }
                    int bytesRead = 0;
                    byte[] buf = new byte[512];
                    while (bytesRead != -1 && !this.interruptPlayback) {
                        bytesRead = audioInputStream.read(buf, 0, buf.length);
                        if (bytesRead < 0) continue;
                        this.audioLine.write(buf, 0, bytesRead);
                    }
                    this.audioLine.drain();
                }
                finally {
                    Simple simple = this;
                    synchronized (simple) {
                        if (this.audioLine != null) {
                            this.audioLine.close();
                            this.audioLine = null;
                        }
                        if (audioInputStream != null) {
                            audioInputStream.close();
                            audioInputStream = null;
                        }
                    }
                    this.finished = true;
                }
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
                log.error("Unable to play audio file" + this.fileName, (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopPlaying() {
            this.interruptPlayback = true;
            Simple simple = this;
            synchronized (simple) {
                if (this.audioLine != null) {
                    this.audioLine.stop();
                }
            }
        }
    }
}

