/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events;

import java.util.Objects;
import java.util.Set;
import org.luwrain.core.Event;
import org.luwrain.core.NullCheck;
import org.luwrain.interaction.KeyboardLayout;
import org.luwrain.interaction.layouts.RuDefault;

public final class InputEvent
extends Event {
    private static KeyboardLayout keyboardLayout = new RuDefault();
    protected boolean isSpecial = false;
    protected Special special = null;
    protected char nonSpecialChar = '\u0000';
    protected boolean shiftPressed = false;
    protected boolean controlPressed = false;
    protected boolean altPressed = false;

    public InputEvent(Special special) {
        Objects.requireNonNull(special, "special can't be null");
        this.isSpecial = true;
        this.special = special;
        this.nonSpecialChar = '\u0000';
        this.shiftPressed = false;
        this.controlPressed = false;
        this.altPressed = false;
    }

    public InputEvent(Special special, Set<Modifiers> modifiers) {
        Objects.requireNonNull(special, "special can't be null");
        Objects.requireNonNull(modifiers, "modifiers can't be null");
        this.isSpecial = true;
        this.special = special;
        this.nonSpecialChar = '\u0000';
        this.shiftPressed = modifiers.contains((Object)Modifiers.SHIFT);
        this.altPressed = modifiers.contains((Object)Modifiers.ALT);
        this.controlPressed = modifiers.contains((Object)Modifiers.CONTROL);
    }

    public InputEvent(Special special, boolean shiftPressed, boolean controlPressed, boolean altPressed) {
        NullCheck.notNull((Object)((Object)special), (String)"special");
        this.isSpecial = true;
        this.special = special;
        this.nonSpecialChar = '\u0000';
        this.shiftPressed = shiftPressed;
        this.controlPressed = controlPressed;
        this.altPressed = altPressed;
    }

    public InputEvent(char nonSpecialChar) {
        this.isSpecial = false;
        this.special = null;
        this.nonSpecialChar = nonSpecialChar;
        this.shiftPressed = false;
        this.controlPressed = false;
        this.altPressed = false;
    }

    public InputEvent(char nonSpecialChar, Set<Modifiers> modifiers) {
        Objects.requireNonNull(modifiers, "modifiers can't be null");
        this.isSpecial = false;
        this.special = null;
        this.nonSpecialChar = nonSpecialChar;
        this.shiftPressed = modifiers.contains((Object)Modifiers.SHIFT);
        this.altPressed = modifiers.contains((Object)Modifiers.ALT);
        this.controlPressed = modifiers.contains((Object)Modifiers.CONTROL);
    }

    public InputEvent(char nonSpecialChar, boolean shiftPressed, boolean controlPressed, boolean altPressed) {
        this.isSpecial = false;
        this.special = null;
        this.nonSpecialChar = nonSpecialChar;
        this.shiftPressed = shiftPressed;
        this.controlPressed = controlPressed;
        this.altPressed = altPressed;
    }

    public InputEvent(boolean isSpecial, Special special, char nonSpecialChar, boolean shiftPressed, boolean controlPressed, boolean altPressed) {
        this.isSpecial = isSpecial;
        this.special = special;
        this.nonSpecialChar = nonSpecialChar;
        this.shiftPressed = shiftPressed;
        this.controlPressed = controlPressed;
        this.altPressed = altPressed;
    }

    public InputEvent(boolean isSpecial, Special special, char nonSpecialChar) {
        this.isSpecial = isSpecial;
        this.special = special;
        this.nonSpecialChar = nonSpecialChar;
        this.shiftPressed = false;
        this.controlPressed = false;
        this.altPressed = false;
    }

    public boolean equals(InputEvent event) {
        return !(this.isSpecial != event.isSpecial || this.isSpecial && this.special != event.special || !this.isSpecial && !keyboardLayout.onSameButton(this.nonSpecialChar, event.nonSpecialChar) || this.shiftPressed != event.shiftPressed || this.controlPressed != event.controlPressed || this.altPressed != event.altPressed);
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public char getChar() {
        return this.nonSpecialChar;
    }

    public Special getSpecial() {
        return this.special;
    }

    public boolean isModified() {
        return this.shiftPressed || this.controlPressed || this.altPressed;
    }

    public boolean withShift() {
        return this.shiftPressed;
    }

    public boolean withShiftOnly() {
        return this.shiftPressed && !this.controlPressed && !this.altPressed;
    }

    public boolean withControl() {
        return this.controlPressed;
    }

    public boolean withControlOnly() {
        return this.controlPressed && !this.shiftPressed && !this.altPressed;
    }

    public boolean withAlt() {
        return this.altPressed;
    }

    public boolean withAltOnly() {
        return this.altPressed && !this.shiftPressed && !this.controlPressed;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.controlPressed) {
            b.append("Ctrl+");
        }
        if (this.altPressed) {
            b.append("Alt+");
        }
        if (this.shiftPressed) {
            b.append("Shift+");
        }
        if (this.isSpecial) {
            b.append((Object)this.special);
        } else {
            b.append(this.nonSpecialChar);
        }
        return new String(b);
    }

    public static Special translateSpecial(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException("value may not be empty");
        }
        switch (value.trim().toLowerCase()) {
            case "enter": {
                return Special.ENTER;
            }
            case "backspace": {
                return Special.BACKSPACE;
            }
            case "escape": {
                return Special.ESCAPE;
            }
            case "tab": {
                return Special.TAB;
            }
            case "ARROW_DOWN": {
                return Special.ARROW_DOWN;
            }
            case "arrow-up": {
                return Special.ARROW_UP;
            }
            case "arrow-left": {
                return Special.ARROW_LEFT;
            }
            case "arrow-right": {
                return Special.ARROW_RIGHT;
            }
            case "insert": {
                return Special.INSERT;
            }
            case "delete": {
                return Special.DELETE;
            }
            case "alternative-delete": {
                return Special.ALTERNATIVE_DELETE;
            }
            case "home": {
                return Special.HOME;
            }
            case "end": {
                return Special.END;
            }
            case "page-up": {
                return Special.PAGE_UP;
            }
            case "page-down": {
                return Special.PAGE_DOWN;
            }
            case "f1": {
                return Special.F1;
            }
            case "f2": {
                return Special.F2;
            }
            case "f3": {
                return Special.F3;
            }
            case "f4": {
                return Special.F4;
            }
            case "f5": {
                return Special.F5;
            }
            case "f6": {
                return Special.F6;
            }
            case "f7": {
                return Special.F7;
            }
            case "f8": {
                return Special.F8;
            }
            case "f9": {
                return Special.F9;
            }
            case "f10": {
                return Special.F10;
            }
            case "f11": {
                return Special.F11;
            }
            case "f12": {
                return Special.F12;
            }
            case "windows": {
                return Special.WINDOWS;
            }
            case "context-menu": {
                return Special.CONTEXT_MENU;
            }
            case "shift": {
                return Special.SHIFT;
            }
            case "control": {
                return Special.CONTROL;
            }
            case "left-alt": {
                return Special.LEFT_ALT;
            }
            case "right-alt": {
                return Special.RIGHT_ALT;
            }
        }
        return null;
    }

    public static KeyboardLayout getKeyboardLayout() {
        return keyboardLayout;
    }

    public static void setKeyboardLayout(KeyboardLayout layout) {
        if (layout == null) {
            throw new NullPointerException("layout may not be null");
        }
        keyboardLayout = layout;
    }

    public static enum Special {
        ENTER,
        BACKSPACE,
        ESCAPE,
        TAB,
        ARROW_DOWN,
        ARROW_UP,
        ARROW_LEFT,
        ARROW_RIGHT,
        INSERT,
        DELETE,
        HOME,
        END,
        PAGE_UP,
        PAGE_DOWN,
        F1,
        F2,
        F3,
        F4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        F11,
        F12,
        WINDOWS,
        CONTEXT_MENU,
        SHIFT,
        CONTROL,
        LEFT_ALT,
        RIGHT_ALT,
        ALTERNATIVE_ARROW_DOWN,
        ALTERNATIVE_ARROW_UP,
        ALTERNATIVE_ARROW_LEFT,
        ALTERNATIVE_ARROW_RIGHT,
        ALTERNATIVE_HOME,
        ALTERNATIVE_END,
        ALTERNATIVE_PAGE_UP,
        ALTERNATIVE_PAGE_DOWN,
        ALTERNATIVE_DELETE;

    }

    public static enum Modifiers {
        ALT,
        SHIFT,
        CONTROL;

    }
}

