/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events.resp;

import java.util.Objects;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.i18n.I18n;
import org.luwrain.i18n.LangStatic;

final class Base {
    Base() {
    }

    static String getSuggestionText(Suggestions suggestion, I18n i18n) {
        Objects.requireNonNull(suggestion, "suggestion");
        Objects.requireNonNull(i18n, "i18n can't be null");
        switch (suggestion) {
            case CLICKABLE_LIST_ITEM: {
                return i18n.getStaticStr("SuggestionClickableListItem");
            }
            case LIST_ITEM: {
                return i18n.getStaticStr("SuggestionListItem");
            }
            case POPUP_LIST_ITEM: {
                return i18n.getStaticStr("SuggestionPopupListItem");
            }
        }
        return null;
    }

    static String getTextForHint(Luwrain luwrain, Hint hint) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)((Object)hint), (String)"hint");
        switch (hint) {
            case SPACES: {
                return luwrain.i18n().getStaticStr("Spaces");
            }
            case TREE_BRANCH_EXPANDED: {
                return "\u0420\u0430\u0441\u043a\u0440\u044b\u0442\u043e";
            }
            case TREE_BRANCH_COLLAPSED: {
                return "\u0441\u0432\u0451\u0440\u043d\u0443\u0442\u043e";
            }
        }
        return luwrain.i18n().staticStr(Base.hintToStaticStrMap(hint));
    }

    static LangStatic hintToStaticStrMap(Hint hint) {
        switch (hint) {
            case SPACE: {
                return LangStatic.SPACE;
            }
            case TAB: {
                return LangStatic.TAB;
            }
            case EMPTY_LINE: {
                return LangStatic.EMPTY_LINE;
            }
            case NO_CONTENT: {
                return LangStatic.NO_CONTENT;
            }
            case BEGIN_OF_LINE: {
                return LangStatic.BEGIN_OF_LINE;
            }
            case END_OF_LINE: 
            case LINE_BOUND: {
                return LangStatic.END_OF_LINE;
            }
            case BEGIN_OF_TEXT: {
                return LangStatic.BEGIN_OF_TEXT;
            }
            case END_OF_TEXT: {
                return LangStatic.END_OF_TEXT;
            }
            case NO_LINES_ABOVE: {
                return LangStatic.NO_LINES_ABOVE;
            }
            case NO_LINES_BELOW: {
                return LangStatic.NO_LINES_BELOW;
            }
            case NO_ITEMS_ABOVE: {
                return LangStatic.NO_ITEMS_ABOVE;
            }
            case NO_ITEMS_BELOW: {
                return LangStatic.NO_ITEMS_BELOW;
            }
            case TREE_BEGIN: {
                return LangStatic.BEGIN_OF_TREE;
            }
            case TREE_END: {
                return LangStatic.END_OF_TREE;
            }
            case TABLE_NO_ROWS_ABOVE: {
                return LangStatic.TABLE_NO_ROWS_ABOVE;
            }
            case TABLE_NO_ROWS_BELOW: {
                return LangStatic.TABLE_NO_ROWS_BELOW;
            }
            case TABLE_END_OF_COL: {
                return LangStatic.TABLE_END_OF_COL;
            }
            case TABLE_BEGIN_OF_ROW: {
                return LangStatic.TABLE_BEGIN_OF_ROW;
            }
            case TABLE_END_OF_ROW: {
                return LangStatic.TABLE_END_OF_ROW;
            }
        }
        return null;
    }

    static Sounds getSoundForHint(Hint hint) {
        NullCheck.notNull((Object)((Object)hint), (String)"hint");
        switch (hint) {
            case NO_ITEMS_ABOVE: 
            case TREE_BEGIN: 
            case TABLE_NO_ROWS_ABOVE: {
                return Sounds.NO_ITEMS_ABOVE;
            }
            case NO_ITEMS_BELOW: 
            case TREE_END: 
            case TABLE_NO_ROWS_BELOW: {
                return Sounds.NO_ITEMS_BELOW;
            }
            case NO_LINES_ABOVE: {
                return Sounds.NO_LINES_ABOVE;
            }
            case BEGIN_OF_LINE: 
            case END_OF_LINE: 
            case BEGIN_OF_TEXT: 
            case END_OF_TEXT: {
                return Sounds.END_OF_LINE;
            }
            case NO_LINES_BELOW: {
                return Sounds.NO_LINES_BELOW;
            }
            case NO_CONTENT: {
                return Sounds.NO_CONTENT;
            }
            case SPACES: 
            case EMPTY_LINE: 
            case LINE_BOUND: {
                return Sounds.EMPTY_LINE;
            }
            case TREE_BRANCH_COLLAPSED: {
                return Sounds.COLLAPSED;
            }
            case TREE_BRANCH_EXPANDED: {
                return Sounds.EXPANDED;
            }
        }
        return null;
    }
}

