/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events.resp;

import java.util.Objects;
import org.luwrain.core.EventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.io.json.CommonSettings;

public class TextResponse
implements EventResponse {
    protected final Sounds sound;
    protected final String text;

    public TextResponse(Sounds sound, String text) {
        Objects.requireNonNull(text, "text can't be null");
        this.sound = sound;
        this.text = text;
    }

    @Override
    public void announce(Luwrain luwrain, EventResponse.Speech speech, CommonSettings sett) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)this.text, (String)"text");
        NullCheck.notNull((Object)speech, (String)"speech");
        luwrain.playSound(this.sound);
        if (!this.text.trim().isEmpty()) {
            speech.speak(new String[]{this.text});
        }
    }
}

