/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.properties;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesProvider;
import org.luwrain.player.Listener;
import org.luwrain.player.Player;
import org.luwrain.player.Playlist;

public final class Player
implements PropertiesProvider,
Listener {
    private static final String PROP_TRACK_INDEX = "luwrain.player.track.index";
    private static final String PROP_TRACK_URL = "luwrain.player.track.url";
    private static final String PROP_TRACK_SEC = "luwrain.player.track.sec";
    private PropertiesProvider.Listener listener = null;
    private int trackNum = 0;
    private String trackUrl = "";
    private long trackTimeMsec = 0L;

    @Override
    public String getExtObjName() {
        return this.getClass().getName();
    }

    @Override
    public String[] getPropertiesRegex() {
        return new String[0];
    }

    @Override
    public Set<PropertiesProvider.Flags> getPropertyFlags(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        String value = this.getProperty(propName);
        if (value != null) {
            return EnumSet.of(PropertiesProvider.Flags.PUBLIC);
        }
        return null;
    }

    @Override
    public String getProperty(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        switch (propName) {
            case "luwrain.player.track.index": {
                return String.valueOf(this.trackNum);
            }
            case "luwrain.player.track.url": {
                return this.trackUrl;
            }
            case "luwrain.player.track.sec": {
                return String.valueOf(this.trackTimeMsec / 1000L);
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(String propName, String value) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        NullCheck.notNull((Object)value, (String)"value");
        return false;
    }

    @Override
    public void setListener(PropertiesProvider.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void onNewPlaylist(Playlist playlist) {
    }

    @Override
    public void onNewTrack(Playlist playlist, int trackNum) {
        NullCheck.notNull((Object)playlist, (String)"playlist");
        this.trackNum = trackNum;
        this.trackUrl = playlist.getTrackUrl(trackNum);
        if (this.listener != null) {
            this.listener.onNewPropertyValue(PROP_TRACK_INDEX, String.valueOf(trackNum));
            this.listener.onNewPropertyValue(PROP_TRACK_URL, this.trackUrl);
        }
    }

    @Override
    public void onTrackTime(Playlist playlist, int trackNum, long msec) {
        NullCheck.notNull((Object)playlist, (String)"playlist");
        if (msec >= this.trackTimeMsec && msec < this.trackTimeMsec + 1000L) {
            return;
        }
        this.trackTimeMsec = msec - msec % 1000L;
        if (this.listener != null) {
            this.listener.onNewPropertyValue(PROP_TRACK_SEC, this.getProperty(PROP_TRACK_SEC));
        }
    }

    @Override
    public void onNewState(Playlist playlist, Player.State state) {
    }

    @Override
    public void onPlayingError(Playlist playlist, Exception e) {
    }
}

