/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.sound;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Configs;
import org.luwrain.core.Sounds;
import org.luwrain.core.WavePlayers;
import org.luwrain.core.sound.Config;

final class Icons {
    private static final Logger log = LogManager.getLogger();
    private final Configs configs;
    private final Map<Sounds, String> soundFiles = new HashMap<Sounds, String>();
    private final Map<Sounds, byte[]> cache = new HashMap<Sounds, byte[]>();
    private WavePlayers.Simple previous = null;

    Icons(Configs configs) {
        this.configs = Objects.requireNonNull(configs, "configs can't be null");
    }

    void load() {
        this.cache.clear();
        this.soundFiles.clear();
        Config conf = this.configs.load(Config.class);
        if (conf != null && conf.icons != null) {
            for (Map.Entry<Sounds, String> e : conf.icons.entrySet()) {
                this.soundFiles.put(e.getKey(), e.getValue());
            }
        }
    }

    void play(Sounds sound, int volumePercent) {
        Objects.requireNonNull(sound, "sound can't be null");
        if (!this.soundFiles.containsKey((Object)sound)) {
            this.loadToCacheFromResource(sound);
        }
        if (this.cache.containsKey((Object)sound)) {
            if (this.previous != null) {
                this.previous.stopPlaying();
            }
            this.previous = new WavePlayers.Simple(new ByteArrayInputStream(this.cache.get((Object)sound)), volumePercent);
            new Thread(this.previous).start();
        }
    }

    void play(File file, int volumePercent) {
        Objects.requireNonNull(file, "file can't be null");
        if (this.previous != null) {
            this.previous.stopPlaying();
        }
        this.previous = new WavePlayers.Simple(file.getAbsolutePath(), volumePercent);
        new Thread(this.previous).start();
    }

    void stop() {
        if (this.previous != null) {
            this.previous.stopPlaying();
        }
    }

    private void loadToCacheFromResource(Sounds sound) {
        Objects.requireNonNull(sound, "sound can't benull");
        if (this.cache.containsKey((Object)sound)) {
            return;
        }
        String name = sound.toString().toLowerCase().replaceAll("_", "-") + ".wav";
        InputStream s = this.getClass().getResourceAsStream(name);
        if (s == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            try (BufferedInputStream is = new BufferedInputStream(s);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            os.flush();
        }
        catch (IOException ex) {
            log.error("Unable to load a sound resource file for " + sound.toString(), (Throwable)ex);
            return;
        }
        this.cache.put(sound, os.toByteArray());
    }
}

