/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.cpanel;

import java.util.Objects;
import org.luwrain.core.Action;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.Element;
import org.luwrain.cpanel.Section;
import org.luwrain.cpanel.SectionArea;

public class DefaultSection
implements Section {
    protected final Element element;
    protected final String name;
    protected final AreaFactory areaFactory;
    protected final ActionHandler actionHandler;
    protected final Action[] actions;
    private SectionArea area = null;

    public DefaultSection(Element element, String name) {
        this.element = Objects.requireNonNull(element, "element can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.areaFactory = null;
        this.actionHandler = null;
        this.actions = new Action[0];
    }

    public DefaultSection(Element element, String name, AreaFactory areaFactory) {
        this.element = Objects.requireNonNull(element, "element can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.areaFactory = areaFactory;
        this.actionHandler = null;
        this.actions = new Action[0];
    }

    public DefaultSection(Element element, String name, AreaFactory areaFactory, Action[] actions, ActionHandler actionHandler) {
        this.element = Objects.requireNonNull(element, "element can't be null");
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.areaFactory = areaFactory;
        this.actions = Objects.requireNonNullElse(actions, new Action[0]);
        this.actionHandler = actionHandler;
    }

    @Override
    public SectionArea getSectionArea(ControlPanel controlPanel) {
        Objects.requireNonNull(controlPanel, "controlPanel can't be null");
        if (this.area != null) {
            return this.area;
        }
        if (this.areaFactory == null) {
            return null;
        }
        this.area = this.areaFactory.newSectionArea(controlPanel);
        return this.area;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public Action[] getSectionActions() {
        return (Action[])this.actions.clone();
    }

    @Override
    public boolean onSectionActionEvent(ControlPanel controlPanel, ActionEvent event) {
        Objects.requireNonNull(controlPanel, "controlPanel can't be null");
        Objects.requireNonNull(event, "event can't be null");
        if (this.actionHandler == null) {
            return false;
        }
        return this.actionHandler.onSectionActionEvent(controlPanel, event);
    }

    public String toString() {
        return this.name;
    }

    public static interface AreaFactory {
        public SectionArea newSectionArea(ControlPanel var1);
    }

    public static interface ActionHandler {
        public boolean onSectionActionEvent(ControlPanel var1, ActionEvent var2);
    }
}

