/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.luwrain.core.EmptyExtension;
import org.luwrain.core.Luwrain;
import org.luwrain.i18n.I18nExtension;
import org.luwrain.util.ResourceUtils;

public class I18nExtensionBase
extends EmptyExtension {
    public static final String COMMAND_PREFIX = "command.";
    public static final String STATIC_PREFIX = "static.";
    public static final String STRINGS_PREFIX = "strings.";
    public static final String CHARS_PREFIX = "chars.";
    protected ClassLoader classLoader = null;
    protected Luwrain luwrain = null;
    protected final String langName;

    protected I18nExtensionBase(String langName) {
        Objects.requireNonNull(langName, "langName can't be null");
        this.langName = langName;
    }

    protected void init(ClassLoader classLoader, Luwrain luwrain) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain");
    }

    protected Map<String, String> readStaticStrings() throws IOException {
        return this.readResource("static.txt");
    }

    protected Map<String, String> readChars() throws IOException {
        return this.readResource("chars.txt");
    }

    protected void loadCommands(I18nExtension ext) throws IOException {
        Map<String, String> res = this.readResource("commands.txt");
        for (Map.Entry<String, String> e : res.entrySet()) {
            ext.addCommandTitle(this.langName, e.getKey(), e.getValue());
        }
    }

    protected Map<String, String> readResource(String resName) throws IOException {
        HashMap<String, String> res = new HashMap<String, String>();
        List<String> lines = ResourceUtils.readStringResourceAsList(this.getClass(), resName, "UTF-8");
        for (String l : lines) {
            int pos;
            if (l.trim().isEmpty() || l.trim().charAt(0) == '#' || (pos = l.indexOf("=")) < 0) continue;
            String key = l.substring(0, pos).trim();
            String value = l.substring(pos + 1).trim();
            if (key.isEmpty() || value.isEmpty()) continue;
            res.put(key, value);
        }
        return res;
    }
}

