/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class PopupClosingTranslator {
    protected final Provider provider;
    protected boolean shouldContinue = true;
    protected boolean cancelled = true;

    public PopupClosingTranslator(Provider provider) {
        NullCheck.notNull((Object)provider, (String)"provider");
        this.provider = provider;
    }

    public boolean doOk() {
        if (!this.provider.onOk()) {
            return false;
        }
        this.cancelled = false;
        this.shouldContinue = false;
        return true;
    }

    public boolean doCancel() {
        if (!this.provider.onCancel()) {
            return false;
        }
        this.cancelled = true;
        this.shouldContinue = false;
        return true;
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public boolean continueEventLoop() {
        return this.shouldContinue;
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!event.isModified() && event.isSpecial() && event.getSpecial() == InputEvent.Special.ESCAPE) {
            return this.doCancel();
        }
        return false;
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case CANCEL: 
            case CLOSE: {
                return this.doCancel();
            }
            case OK: {
                return this.doOk();
            }
        }
        return false;
    }

    public static interface Provider {
        public boolean onOk();

        public boolean onCancel();
    }
}

