/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.EmbeddedEdit;
import org.luwrain.controls.EmbeddedEditLines;
import org.luwrain.controls.RegionPoint;
import org.luwrain.controls.RegionTextQueryTranslator;
import org.luwrain.core.Action;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.popups.PopupClosingTranslator;
import org.luwrain.util.WordIterator;

public class SimpleEditPopup
implements Popup,
PopupClosingTranslator.Provider,
HotPointControl,
EmbeddedEditLines,
ClipboardTranslator.Provider,
RegionTextQueryTranslator.Provider {
    protected final Luwrain luwrain;
    protected final PopupClosingTranslator closing = new PopupClosingTranslator(this);
    protected final RegionPoint regionPoint = new RegionPoint();
    protected final ClipboardTranslator clipboardTranslator = new ClipboardTranslator(this, this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
    protected final RegionTextQueryTranslator regionTextQueryTranslator = new RegionTextQueryTranslator(this, this.regionPoint, EnumSet.noneOf(RegionTextQueryTranslator.Flags.class));
    protected final EmbeddedEdit edit;
    protected final String name;
    protected final String prefix;
    protected String text;
    protected int pos;
    protected final Set<Popup.Flags> popupFlags;

    public SimpleEditPopup(Luwrain luwrain, String name, String prefix, String text, Set<Popup.Flags> popupFlags) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull(popupFlags, (String)"popupFlags");
        this.luwrain = luwrain;
        this.name = name;
        this.prefix = prefix;
        this.text = text;
        this.popupFlags = popupFlags;
        this.pos = prefix.length() + text.length();
        this.edit = new EmbeddedEdit(new DefaultControlContext(luwrain), this, this, this.regionPoint, prefix.length(), 0);
    }

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public String getLine(int index) {
        return index == 0 ? this.prefix + this.text : "";
    }

    @Override
    public int getHotPointX() {
        return this.pos;
    }

    @Override
    public int getHotPointY() {
        return 0;
    }

    protected String getSpeakableText(String prefix, String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return prefix + text;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.closing.onInputEvent(event)) {
            return true;
        }
        if (this.edit.isPosCovered(this.pos, 0) && this.edit.onInputEvent(event)) {
            return true;
        }
        if (!event.isSpecial() || event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case ARROW_LEFT: {
                return this.onMoveLeft(event);
            }
            case ARROW_RIGHT: {
                return this.onMoveRight(event);
            }
            case ALTERNATIVE_ARROW_LEFT: {
                return this.onAltLeft(event);
            }
            case ALTERNATIVE_ARROW_RIGHT: {
                return this.onAltRight(event);
            }
            case HOME: {
                return this.onHome(event);
            }
            case END: {
                return this.onEnd(event);
            }
            case ENTER: {
                this.closing.doOk();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case INTRODUCE: {
                this.luwrain.speak(this.getSpeakableText(this.prefix, this.text), Sounds.POPUP);
                return true;
            }
        }
        if (this.edit.isPosCovered(this.pos, 0) && this.edit.onSystemEvent(event)) {
            return true;
        }
        if (this.clipboardTranslator.onSystemEvent(event, this.pos, 0)) {
            return true;
        }
        if (this.regionTextQueryTranslator.onSystemEvent(event, this.pos, 0)) {
            return true;
        }
        return this.closing.onSystemEvent(event);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        if (this.edit.isPosCovered(this.pos, 0) && this.edit.onAreaQuery(query)) {
            return true;
        }
        return this.regionTextQueryTranslator.onAreaQuery(query, this.getHotPointX(), this.getHotPointY());
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public String getAreaName() {
        return this.name;
    }

    public String text() {
        return this.text;
    }

    protected boolean onMoveLeft(InputEvent event) {
        if (this.pos == 0) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        --this.pos;
        String line = this.prefix + this.text;
        if (this.pos < line.length()) {
            this.luwrain.setEventResponse(DefaultEventResponse.letter(line.charAt(this.pos)));
        } else {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        }
        this.luwrain.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onMoveRight(InputEvent event) {
        String line = this.prefix + this.text;
        if (this.pos >= line.length()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        ++this.pos;
        if (this.pos < line.length()) {
            this.luwrain.setEventResponse(DefaultEventResponse.letter(line.charAt(this.pos)));
        } else {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        }
        this.luwrain.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onHome(InputEvent event) {
        this.pos = 0;
        String line = this.prefix + this.text;
        if (line.isEmpty()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        } else {
            this.luwrain.setEventResponse(DefaultEventResponse.letter(line.charAt(this.pos)));
        }
        this.luwrain.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onEnd(InputEvent event) {
        String line = this.prefix + this.text;
        this.pos = line.length();
        this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        this.luwrain.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onAltRight(InputEvent event) {
        String line = this.prefix + this.text;
        if (line.isEmpty()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.pos >= line.length()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        WordIterator it = new WordIterator(line, this.pos);
        if (!it.stepForward()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        this.pos = it.pos();
        if (it.announce().length() > 0) {
            this.luwrain.speak(this.getSpeakableText("", it.announce()));
        } else {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        }
        this.luwrain.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onAltLeft(InputEvent event) {
        String line = this.prefix + this.text;
        if (line.isEmpty()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        WordIterator it = new WordIterator(line, this.pos);
        if (!it.stepBackward()) {
            this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        this.pos = it.pos();
        this.luwrain.speak(this.getSpeakableText("", it.announce()));
        this.luwrain.onAreaNewHotPoint(this);
        return true;
    }

    @Override
    public String getEmbeddedEditLine(int editPosX, int editPosY) {
        return this.text;
    }

    @Override
    public void setEmbeddedEditLine(int editPosX, int editPosY, String value) {
        this.text = value != null ? value : "";
        this.luwrain.onAreaNewContent(this);
    }

    @Override
    public void setHotPointX(int value) {
        if (value < 0) {
            return;
        }
        this.pos = value;
        this.luwrain.onAreaNewHotPoint(this);
    }

    @Override
    public void setHotPointY(int value) {
    }

    @Override
    public void beginHotPointTrans() {
    }

    @Override
    public void endHotPointTrans() {
    }

    @Override
    public boolean onOk() {
        return true;
    }

    @Override
    public boolean onCancel() {
        return true;
    }

    protected String getTextBeforeHotPoint() {
        if (this.text == null) {
            return "";
        }
        int offset = this.pos - this.prefix.length();
        if (offset < 0) {
            return "";
        }
        if (offset >= this.text.length()) {
            return this.text;
        }
        return this.text.substring(0, offset);
    }

    protected String getTextAfterHotPoint() {
        if (this.text == null) {
            return "";
        }
        int offset = this.pos - this.prefix.length();
        if (offset < 0) {
            return this.text;
        }
        if (offset >= this.text.length()) {
            return "";
        }
        return this.text.substring(offset);
    }

    protected void setText(String beforeHotPoint, String afterHotPoint) {
        if (beforeHotPoint == null || afterHotPoint == null) {
            return;
        }
        this.text = beforeHotPoint + afterHotPoint;
        this.pos = this.prefix.length() + beforeHotPoint.length();
        this.luwrain.onAreaNewContent(this);
        this.luwrain.onAreaNewHotPoint(this);
    }

    @Override
    public String onRegionTextQuery(int fromX, int fromY, int toX, int toY) {
        if (fromX < 0 || toX < 0) {
            throw new IllegalArgumentException("fromX (" + fromX + ") and toX (" + toX + ") may not be less than zero");
        }
        String value = this.prefix + this.text;
        return value.substring(Math.min(fromX, value.length()), Math.min(toX, value.length()));
    }

    @Override
    public boolean onClipboardCopyAll() {
        this.luwrain.getClipboard().set(this.prefix + this.text);
        return true;
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        int toPos;
        if (withDeleting) {
            return false;
        }
        String line = this.prefix + this.text;
        if (line.isEmpty()) {
            return false;
        }
        int fromPos = Math.min(fromX, line.length());
        if (fromPos >= (toPos = Math.min(toX, line.length()))) {
            return false;
        }
        this.luwrain.getClipboard().set(line.substring(fromPos, toPos));
        return true;
    }

    @Override
    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        return false;
    }

    @Override
    public Luwrain getLuwrainObject() {
        return this.luwrain;
    }

    @Override
    public boolean isPopupActive() {
        return this.closing.continueEventLoop();
    }

    @Override
    public Set<Popup.Flags> getPopupFlags() {
        return this.popupFlags;
    }

    public boolean wasCancelled() {
        return this.closing.cancelled();
    }
}

