/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script;

import java.util.concurrent.CompletableFuture;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.NullCheck;

public interface AsyncFunction {
    public void run(Value[] var1, CompletableFuture<Object> var2);

    public static ProxyExecutable create(Context context, Object syncObj, AsyncFunction f) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)syncObj, (String)"syncObj");
        NullCheck.notNull((Object)f, (String)"f");
        return args -> {
            CompletableFuture<Object> res = new CompletableFuture<Object>();
            f.run(args, res);
            return AsyncFunction.wrapCompletableFuture(context, res, syncObj);
        };
    }

    public static Value wrapCompletableFuture(Context context, CompletableFuture<Object> f, Object syncObj) {
        Value promiseConstructor = context.getBindings("js").getMember("Promise");
        return promiseConstructor.newInstance(new Object[]{arguments -> {
            Value resolve = arguments[0];
            Value reject = arguments[1];
            f.whenComplete((result, ex) -> {
                Object object = syncObj;
                synchronized (object) {
                    if (result != null) {
                        resolve.execute(new Object[]{result});
                    } else {
                        reject.execute(new Object[]{ex});
                    }
                }
            });
            return null;
        }});
    }
}

