/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.app;

import java.io.File;
import org.graalvm.polyglot.Value;
import org.luwrain.controls.CenteredArea;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.core.InputEventObj;
import org.luwrain.script.core.SystemEventObj;
import org.luwrain.util.Urls;

public final class Simple
implements Application {
    private final String name;
    private final File dataDir;
    private final Value jsApp;
    private final Object syncObj;
    private Luwrain luwrain = null;
    private CenteredArea area = null;
    private String bkgSound = "";

    public Simple(String name, File dataDir, Value jsApp, Object syncObj) {
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)dataDir, (String)"dataDir");
        NullCheck.notNull((Object)jsApp, (String)"jsApp");
        NullCheck.notNull((Object)syncObj, (String)"syncObj");
        this.name = name;
        this.dataDir = dataDir;
        this.jsApp = jsApp;
        this.syncObj = syncObj;
    }

    @Override
    public InitResult onLaunchApp(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.createArea();
        return new InitResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createArea() {
        this.area = new CenteredArea(new DefaultControlContext(this.luwrain), this.name){

            @Override
            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (Simple.this.handleInputEvent(event)) {
                    return true;
                }
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case ESCAPE: {
                            Simple.this.luwrain.closeApp();
                            return true;
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                if (Simple.this.handleSystemEvent(event)) {
                    return true;
                }
                switch (event.getCode()) {
                    case CLOSE: {
                        Simple.this.closeApp();
                        return true;
                    }
                }
                return super.onSystemEvent(event);
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                switch (query.getQueryCode()) {
                    case 7: {
                        if (Simple.this.bkgSound.isEmpty()) {
                            return false;
                        }
                        File f = new File(Simple.this.dataDir, Simple.this.bkgSound);
                        ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(Urls.toUrl(f).toString()));
                        return true;
                    }
                }
                return super.onAreaQuery(query);
            }
        };
        Object object = this.syncObj;
        synchronized (object) {
            String[] lines = this.requestLines();
            if (lines != null) {
                this.area.setLines(lines);
            }
            int hotPointX = this.requestHotPointX();
            int hotPointY = this.requestHotPointY();
            this.area.setLocalHotPointX(hotPointX >= 0 ? hotPointX : 0);
            this.area.setLocalHotPointY(hotPointY >= 0 ? hotPointY : 0);
            this.bkgSound = this.requestBkgSound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        Object object = this.syncObj;
        synchronized (object) {
            Value resValue;
            Value funcObj = ScriptUtils.getMember(this.jsApp, "onInputEvent");
            if (funcObj == null || !(funcObj instanceof Value)) {
                return false;
            }
            Value func = funcObj;
            if (func.isNull() || !func.canExecute()) {
                return false;
            }
            InputEventObj arg = new InputEventObj(event);
            Value res = func.execute(new Object[]{arg});
            if (res != null && res instanceof Value && !(resValue = res).isNull() && resValue.isBoolean() && resValue.asBoolean()) {
                this.updateLines();
                this.updateHotPoint();
                this.updateBkgSound();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        Object object = this.syncObj;
        synchronized (object) {
            Value resValue;
            Value funcObj = ScriptUtils.getMember(this.jsApp, "onSystemEvent");
            if (funcObj == null || !(funcObj instanceof Value)) {
                return false;
            }
            Value func = funcObj;
            if (func.isNull() || !func.canExecute()) {
                return false;
            }
            SystemEventObj arg = new SystemEventObj(event);
            Value res = func.execute(new Object[]{arg});
            if (res != null && res instanceof Value && !(resValue = res).isNull() && resValue.isBoolean() && resValue.asBoolean()) {
                this.updateLines();
                this.updateHotPoint();
                this.updateBkgSound();
                return true;
            }
            return false;
        }
    }

    private String[] requestLines() {
        String[] res = ScriptUtils.asStringArray(ScriptUtils.getMember(this.jsApp, "lines"));
        return res != null ? res : new String[]{};
    }

    private int requestHotPointX() {
        return Math.max(0, ScriptUtils.asInt(ScriptUtils.getMember(this.jsApp, "hotPointX")));
    }

    private int requestHotPointY() {
        return Math.max(0, ScriptUtils.asInt(ScriptUtils.getMember(this.jsApp, "hotPointY")));
    }

    private String requestBkgSound() {
        String res = ScriptUtils.asString(ScriptUtils.getMember(this.jsApp, "bkgSound"));
        return res != null ? res : "";
    }

    private void updateLines() {
        String[] newLines = this.requestLines();
        if (!this.theSameLines(newLines)) {
            this.area.setLines(newLines);
        }
    }

    private void updateHotPoint() {
        int newX = this.requestHotPointX();
        int newY = this.requestHotPointY();
        if (newX != this.area.getLocalHotPointX() || newY != this.area.getLocalHotPointY()) {
            this.area.setLocalHotPointX(newX);
            this.area.setLocalHotPointY(newY);
        }
    }

    private void updateBkgSound() {
        String value = this.requestBkgSound();
        if (!this.bkgSound.equals(value)) {
            this.bkgSound = value;
            this.luwrain.onAreaNewBackgroundSound(this.area);
        }
    }

    private boolean theSameLines(String[] value) {
        NullCheck.notNullItems((Object[])value, (String)"value");
        String[] lines = this.area.getLines();
        if (value.length != lines.length) {
            return false;
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i].equals(lines[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public AreaLayout getAreaLayout() {
        return new AreaLayout(this.area);
    }

    @Override
    public String getAppName() {
        return this.name;
    }

    public void closeApp() {
        this.luwrain.closeApp();
    }

    @Override
    public void onAppClose() {
    }
}

