/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.controls;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.controls.edit.TextEditAction;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;
import org.luwrain.script.Hooks;
import org.luwrain.script.core.HotPointObj;
import org.luwrain.script.core.MapScriptObject;
import org.luwrain.script.core.MutableLinesArray;

public class EditCorrectorHooks
implements MultilineEditCorrector {
    protected final HookContainer context;
    protected final MultilineEditCorrector base;
    protected final String hookNameBase;

    public EditCorrectorHooks(HookContainer hookContainer, MultilineEdit.Model base, String hookNameBase) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        NullCheck.notNull((Object)base, (String)"base");
        NullCheck.notEmpty((Object)hookNameBase, (String)"hookNameBase");
        this.context = hookContainer;
        this.base = (MultilineEditCorrector)base;
        this.hookNameBase = hookNameBase;
    }

    @Override
    public String getLine(int index) {
        return this.base.getLine(index);
    }

    @Override
    public int getLineCount() {
        return this.base.getLineCount();
    }

    @Override
    public int getHotPointX() {
        return this.base.getHotPointX();
    }

    @Override
    public int getHotPointY() {
        return this.base.getHotPointY();
    }

    @Override
    public String getTabSeq() {
        return this.base.getTabSeq();
    }

    @Override
    public MultilineEdit.ModificationResult deleteChar(int pos, int lineIndex) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!this.runPre(this.hookNameBase + ".delete.char.pre", values)) {
            return new MultilineEdit.ModificationResult(false);
        }
        MultilineEdit.ModificationResult res = this.base.deleteChar(pos, lineIndex);
        if (res.isPerformed()) {
            this.runPost(this.hookNameBase + ".delete.char.post", values);
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult deleteRegion(int fromX, int fromY, int toX, int toY) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!this.runPre(this.hookNameBase + ".delete.region.pre", values)) {
            return new MultilineEdit.ModificationResult(false);
        }
        MultilineEdit.ModificationResult res = this.base.deleteRegion(fromX, fromY, toX, toY);
        if (res.isPerformed()) {
            this.runPost(this.hookNameBase + ".delete.region.post", values);
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult insertRegion(int x, int y, String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!this.runPre(this.hookNameBase + ".insert.region.pre", values)) {
            return new MultilineEdit.ModificationResult(false);
        }
        MultilineEdit.ModificationResult res = this.base.insertRegion(x, y, lines);
        if (res.isPerformed()) {
            this.runPost(this.hookNameBase + ".insert.region.post", values);
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult putChars(int pos, int lineIndex, String str) {
        NullCheck.notNull((Object)str, (String)"str");
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("chars", str);
        values.put("x", pos);
        values.put("y", lineIndex);
        if (!this.runPre(this.hookNameBase + ".insert.chars.pre", values)) {
            return new MultilineEdit.ModificationResult(false);
        }
        MultilineEdit.ModificationResult res = this.base.putChars(pos, lineIndex, str);
        if (res.isPerformed()) {
            this.runPost(this.hookNameBase + ".insert.chars.post", values);
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult mergeLines(int firstLineIndex) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!this.runPre(this.hookNameBase + ".merge.lines.pre", values)) {
            return new MultilineEdit.ModificationResult(false);
        }
        MultilineEdit.ModificationResult res = this.base.mergeLines(firstLineIndex);
        if (res.isPerformed()) {
            this.runPost(this.hookNameBase + ".merge.lines.post", values);
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult splitLine(int pos, int lineIndex) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!this.runPre(this.hookNameBase + ".split.lines.pre", values)) {
            return new MultilineEdit.ModificationResult(false);
        }
        MultilineEdit.ModificationResult res = this.base.splitLine(pos, lineIndex);
        if (res.isPerformed()) {
            this.runPost(this.hookNameBase + ".split.post", values);
        }
        return res;
    }

    @Override
    public MultilineEdit.ModificationResult doEditAction(TextEditAction action) {
        NullCheck.notNull((Object)action, (String)"action");
        HashMap readONlyValues = new HashMap();
        HashMap values = new HashMap();
        return this.base.doEditAction(action);
    }

    protected boolean runPre(String hookName, Map<String, Object> values) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNull(values, (String)"readOnlyValues");
        AtomicBoolean res = new AtomicBoolean(true);
        this.doEditAction((lines, hotPoint) -> {
            HashMap<String, Object> arg = new HashMap<String, Object>(values);
            arg.put("lines", new MutableLinesArray(lines));
            arg.put("hotPoint", new HotPointObj(hotPoint));
            res.set(Hooks.permission(this.context, hookName, new Object[]{new MapScriptObject(arg)}));
        });
        return res.get();
    }

    protected void runPost(String hookName, Map<String, Object> values) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNull(values, (String)"readOnlyValues");
        this.doEditAction((lines, hotPoint) -> {
            HashMap<String, Object> arg = new HashMap<String, Object>(values);
            arg.put("lines", new MutableLinesArray(lines));
            arg.put("hotPoint", new HotPointObj(hotPoint));
            Hooks.notification(this.context, hookName, new Object[]{new MapScriptObject(arg)});
        });
    }
}

