/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.controls;

import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.WizardArea;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.core.InputEventObj;
import org.luwrain.script.core.Module;

public class WizardAreaObj
extends WizardArea {
    final Module module;
    final Value onInput;
    @HostAccess.Export
    public ProxyExecutable createFrame = this::createFrameImpl;

    public WizardAreaObj(ControlContext context, Module module, Value onInput) {
        super(context);
        NullCheck.notNull((Object)module, (String)"module");
        this.module = module;
        this.onInput = onInput;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        Value res;
        NullCheck.notNull((Object)event, (String)"event");
        if (this.onInput != null && (res = this.onInput.execute(new Object[]{new InputEventObj(event)})) != null && !res.isNull() && res.isBoolean() && res.asBoolean()) {
            return true;
        }
        return super.onInputEvent(event);
    }

    public Object createFrameImpl(Value[] args) {
        WizardArea.Frame frame = this.newFrame();
        return new FrameObj(frame);
    }

    public final class FrameObj {
        final WizardArea.Frame frame;
        @HostAccess.Export
        public ProxyExecutable addText = this::addTextImpl;
        @HostAccess.Export
        public ProxyExecutable addInput = this::addInputImpl;
        @HostAccess.Export
        public ProxyExecutable addClickable = this::addClickableImpl;
        @HostAccess.Export
        public ProxyExecutable show = this::showImpl;

        FrameObj(WizardArea.Frame frame) {
            NullCheck.notNull((Object)frame, (String)"frame");
            this.frame = frame;
        }

        public Object addTextImpl(Value[] args) {
            if (!ScriptUtils.notNullAndLen(args, 1) || !args[0].isString()) {
                throw new IllegalArgumentException("Frame.addText() takes exactly one string argument");
            }
            this.frame.addText(args[0].asString());
            return this;
        }

        public Object addInputImpl(Value[] args) {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("The frame function addInput() can't be called without arguments");
            }
            if (args[0] == null || !args[0].isString()) {
                throw new IllegalArgumentException("The frame function addInput() takes a string as the first argument");
            }
            if (args.length == 1) {
                this.frame.addInput(args[0].asString(), "");
                return this;
            }
            if (args[1] == null || !args[1].isString()) {
                throw new IllegalArgumentException("The frame function addInput() takes a string as the second argument");
            }
            this.frame.addInput(args[0].asString(), args[1].asString());
            return this;
        }

        public Object addClickableImpl(Value[] args) {
            if (args == null || args.length != 2) {
                throw new IllegalArgumentException("The frame function addClickable() takes two arguments: the text and the handler");
            }
            if (args[0] == null || !args[0].isString()) {
                throw new IllegalArgumentException("The frame function addClickable() takes a string as the first argument");
            }
            if (args[1] == null || !args[1].canExecute()) {
                throw new IllegalArgumentException("The frame function addClickable() takes a function as the second argument");
            }
            this.frame.addClickable(args[0].asString(), values -> {
                WizardAreaObj.this.module.execFuncValue(args[1]);
                return true;
            });
            return this;
        }

        private Object showImpl(Value[] args) {
            WizardAreaObj.this.show(this.frame);
            return null;
        }
    }
}

