/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.NullCheck;

public class MapScriptObject
implements ProxyObject {
    final Map<String, Object> members;
    ProxyArray membersCache = null;

    public MapScriptObject(Map<String, Object> members) {
        NullCheck.notNull(members, (String)"members");
        this.members = members;
    }

    public MapScriptObject() {
        this(new HashMap<String, Object>());
    }

    public Object getMember(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        Object obj = this.members.get(name);
        return obj;
    }

    public boolean hasMember(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        return this.members.containsKey(name);
    }

    public Object getMemberKeys() {
        if (this.membersCache != null) {
            return this.membersCache;
        }
        ArrayList<String> m = new ArrayList<String>();
        for (Map.Entry<String, Object> e : this.members.entrySet()) {
            m.add(e.getKey());
        }
        this.membersCache = ProxyArray.fromArray((Object[])m.toArray(new String[m.size()]));
        return this.membersCache;
    }

    public void putMember(String name, Value value) {
        NullCheck.notEmpty((Object)name, (String)"name");
        if (value != null) {
            this.members.put(name, value);
        } else {
            this.members.remove(value);
        }
        this.membersCache = null;
    }

    public MapScriptObject add(String name, Object value) {
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)value, (String)"value");
        this.members.put(name, value);
        this.membersCache = null;
        return this;
    }

    public void updateMembersCache() {
        this.membersCache = null;
    }
}

