/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.polyglot.Value;
import org.luwrain.core.Command;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.ScriptFile;
import org.luwrain.core.ScriptSource;
import org.luwrain.core.ScriptText;
import org.luwrain.script.core.Bindings;
import org.luwrain.script.core.InternalCoreFuncs;
import org.luwrain.script.core.Module;
import org.luwrain.util.LineIterator;

public final class ScriptCore
implements HookContainer,
AutoCloseable {
    private static final String LOG_COMPONENT = "script";
    private final Bindings bindings;
    private final Luwrain luwrain;
    private final InternalCoreFuncs internalCoreFuncs;
    private final List<Module> modules = new ArrayList<Module>();

    public ScriptCore(Luwrain luwrain, InternalCoreFuncs internalCoreFuncs, Bindings bindings) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.internalCoreFuncs = internalCoreFuncs;
        this.bindings = bindings;
    }

    public ScriptCore(Luwrain luwrain, Bindings bindings) {
        this(luwrain, null, bindings);
    }

    public ScriptCore(Luwrain luwrain) {
        this(luwrain, null, null);
    }

    @Override
    public void close() {
        for (Module m : this.modules) {
            m.close();
        }
    }

    private void load(Reader reader) throws IOException {
        NullCheck.notNull((Object)reader, (String)"reader");
        String lineSep = System.lineSeparator();
        StringBuilder b = new StringBuilder();
        BufferedReader r = new BufferedReader(reader);
        String line = r.readLine();
        while (line != null) {
            b.append(line).append(lineSep);
            line = r.readLine();
        }
        Module m = new Module(this.luwrain, this.internalCoreFuncs, this.bindings);
        m.eval(new String(b));
        this.modules.add(m);
    }

    public void load(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        Module m = new Module(this.luwrain, this.bindings);
        m.eval(LineIterator.join(file, "UTF-8", System.lineSeparator()));
        this.modules.add(m);
    }

    public void load(ScriptSource scriptSource) throws IOException {
        NullCheck.notNull((Object)scriptSource, (String)"scriptSource");
        Log.debug(LOG_COMPONENT, "loading " + scriptSource.toString());
        if (scriptSource instanceof ScriptFile) {
            ScriptFile f = (ScriptFile)scriptSource;
            this.load(f.asFile());
            return;
        }
        if (scriptSource instanceof ScriptText) {
            ScriptText t = (ScriptText)scriptSource;
            this.load(new StringReader(t.getText()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runHooks(String hookName, HookContainer.HookRunner runner) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        try {
            for (Module m : this.modules) {
                if (!m.luwrainObj.hooks.containsKey(hookName)) continue;
                for (Value v : m.luwrainObj.hooks.get(hookName)) {
                    HookContainer.HookResult res;
                    Object object = m.luwrainObj.syncObj;
                    synchronized (object) {
                        res = runner.runHook(args -> v.execute(args));
                    }
                    if (res == null) {
                        return false;
                    }
                    if (res != HookContainer.HookResult.BREAK) continue;
                    return false;
                }
            }
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "running of the hook '" + hookName + "' failed: " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ExtensionObject[] getExtObjects() {
        ArrayList<ExtensionObject> res = new ArrayList<ExtensionObject>();
        for (Module m : this.modules) {
            res.addAll(m.luwrainObj.extObjs);
        }
        return res.toArray(new ExtensionObject[res.size()]);
    }

    public Command[] getCommands() {
        ArrayList<Command> res = new ArrayList<Command>();
        for (Module m : this.modules) {
            res.addAll(m.luwrainObj.commands);
        }
        return res.toArray(new Command[res.size()]);
    }
}

