/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.luwrain.core.Application;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Shortcut;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.app.Simple;
import org.luwrain.script.core.Module;

final class ShortcutImpl
implements Shortcut {
    private final Module module;
    private final String name;
    private final File dataDir;
    private final Value cons;

    ShortcutImpl(Module module, String name, File dataDir, Value cons) {
        NullCheck.notNull((Object)module, (String)"module");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)dataDir, (String)"dataDir");
        NullCheck.notNull((Object)cons, (String)"cons");
        this.module = module;
        this.name = name;
        this.dataDir = dataDir;
        this.cons = cons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Application[] prepareApp(String[] args) {
        NullCheck.notNullItems((Object[])args, (String)"args");
        Object object = this.module.syncObj;
        synchronized (object) {
            Value newObj = this.cons.newInstance(new Object[]{ProxyArray.fromArray((Object[])args)});
            if (newObj == null || newObj.isNull()) {
                return null;
            }
            String name = ScriptUtils.asString(ScriptUtils.getMember(newObj, "name"));
            String type = ScriptUtils.asString(ScriptUtils.getMember(newObj, "type"));
            if (name == null || name.trim().isEmpty()) {
                return null;
            }
            if (type == null) {
                return null;
            }
            switch (type.trim().toUpperCase()) {
                case "SIMPLE": {
                    return new Application[]{new Simple(name, this.dataDir, newObj, this.module.syncObj)};
                }
            }
            return null;
        }
    }

    @Override
    public String getExtObjName() {
        return this.name;
    }

    @Override
    public Set<Shortcut.Flags> getShortcutFlags() {
        return EnumSet.noneOf(Shortcut.Flags.class);
    }

    @Override
    public String[] getFileExtensions() {
        return new String[0];
    }
}

