/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;

class HardwareCpuMem
extends SimpleArea
implements SectionArea {
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;

    HardwareCpuMem(ControlPanel controlPanel) {
        super(new DefaultControlContext(controlPanel.getCoreInterface()), "\u041f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440 \u0438 \u043f\u0430\u043c\u044f\u0442\u044c");
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.fillData();
    }

    private void fillData() {
        this.update(lines -> {
            String cpu;
            int i = 0;
            while (!(cpu = this.luwrain.getProperty("luwrain.hardware.cpu." + i)).trim().isEmpty()) {
                lines.add("\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440 " + (i + 1) + ": " + cpu);
                if (++i < 1024) continue;
                break;
            }
            lines.add("\u041e\u0431\u044a\u0451\u043c \u043e\u043f\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438 (\u041c\u0411): " + this.luwrain.getProperty("luwrain.hardware.ramsizemb"));
            lines.add("");
        });
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean saveSectionData() {
        return true;
    }

    static HardwareCpuMem create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        return new HardwareCpuMem(controlPanel);
    }
}

