/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.list.ListModel;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.io.json.HotKey;

final class HotKeys
extends ListArea<Item>
implements SectionArea {
    private final ControlPanel controlPanel;

    HotKeys(ControlPanel controlPanel, ListArea.Params<Item> params) {
        super(params);
        this.controlPanel = Objects.requireNonNull(controlPanel, "controlPanel can't be empty");
        this.setListClickHandler((area, index, item) -> this.editItem((Item)item));
    }

    @Override
    public boolean saveSectionData() {
        return true;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    private boolean editItem(Item item) {
        return false;
    }

    private static List<Item> loadItems(Luwrain luwrain) {
        org.luwrain.io.json.HotKeys conf = luwrain.loadConf(org.luwrain.io.json.HotKeys.class);
        if (conf == null || conf.getHotKeys() == null) {
            return new ArrayList<Item>();
        }
        return conf.getHotKeys().stream().map(e -> new Item(luwrain, (HotKey)e)).toList();
    }

    static HotKeys create(ControlPanel controlPanel) {
        Objects.requireNonNull(controlPanel, "controlPanel can't be null");
        Luwrain luwrain = controlPanel.getCoreInterface();
        ListArea.Params<Item> params = new ListArea.Params<Item>();
        params.context = new DefaultControlContext(luwrain);
        params.appearance = new ListUtils.DefaultAppearance(params.context, Suggestions.LIST_ITEM);
        params.name = luwrain.getString("static:CpHotKeys");
        params.model = new ListModel<Item>(HotKeys.loadItems(luwrain));
        return new HotKeys(controlPanel, params);
    }

    static final class Item
    implements Comparable {
        final String command;
        final String title;
        final InputEvent event;

        Item(Luwrain luwrain, HotKey hotKey) {
            this.command = Objects.requireNonNullElse(hotKey.getCommand(), "");
            this.event = hotKey.getInputEvent();
            this.title = luwrain.i18n().getCommandTitle(this.command);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.title).append(": ");
            b.append(Item.hotKeyToString(this.event));
            return new String(b);
        }

        public int compareTo(Object o) {
            if (o != null && o instanceof Item) {
                Item item = (Item)o;
                return this.command.compareTo(item.command);
            }
            return 0;
        }

        private static String hotKeyToString(InputEvent event) {
            StringBuilder b = new StringBuilder();
            if (event.withControl()) {
                b.append("Ctrl+");
            }
            if (event.withAlt()) {
                b.append("Alt+");
            }
            if (event.withShift()) {
                b.append("Shift+");
            }
            if (!event.isSpecial()) {
                b.append(Character.toString(Character.toUpperCase(event.getChar())));
            } else {
                b.append(event.getSpecial().toString());
            }
            return new String(b);
        }
    }
}

