/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Settings;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.util.TextUtils;

final class PersonalInfo
extends FormArea
implements SectionArea {
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;
    private final Settings.PersonalInfo sett;

    PersonalInfo(ControlPanel controlPanel) {
        super(new DefaultControlContext(controlPanel.getCoreInterface()), controlPanel.getCoreInterface().i18n().getStaticStr("CpPersonalInfoSection"));
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.sett = null;
        this.fillForm();
    }

    private void fillForm() {
        this.addEdit("name", this.luwrain.i18n().getStaticStr("CpPersonalInfoFullName"), this.sett.getFullName(""), null, true);
        this.addEdit("address", this.luwrain.i18n().getStaticStr("CpPersonalInfoMailAddress"), this.sett.getDefaultMailAddress(""), null, true);
        this.activateMultilineEdit(this.luwrain.i18n().getStaticStr("CpPersonalInfoSignature"), TextUtils.splitLines(this.sett.getSignature("")), true);
    }

    @Override
    public boolean saveSectionData() {
        Luwrain luwrain = this.controlPanel.getCoreInterface();
        this.sett.setFullName(this.getEnteredText("name"));
        this.sett.setDefaultMailAddress(this.getEnteredText("address"));
        this.sett.setSignature(this.getMultilineEditText("\n"));
        return true;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }
}

