/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.io.File;
import java.util.ArrayList;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.player.FixedPlaylist;
import org.luwrain.player.Player;
import org.luwrain.popups.Popups;
import org.luwrain.util.Urls;

final class SoundsList
extends ListArea<Item>
implements SectionArea,
ListArea.ClickHandler<Item> {
    private static final Sounds[] allSounds = new Sounds[]{Sounds.ANNOUNCEMENT, Sounds.ATTENTION, Sounds.BLOCKED, Sounds.CANCEL, Sounds.CHAT_MESSAGE, Sounds.CLICK, Sounds.COMMANDER_LOCATION, Sounds.COPIED, Sounds.CUT, Sounds.DELETED, Sounds.DESKTOP_ITEM, Sounds.DOC_SECTION, Sounds.DONE, Sounds.EMPTY_LINE, Sounds.END_OF_LINE, Sounds.ERROR, Sounds.INACCESSIBLE, Sounds.FATAL, Sounds.GENERAL_TIME, Sounds.AREA_LAYOUT, Sounds.POPUP, Sounds.INTRO_REGULAR, Sounds.LIST_ITEM, Sounds.MAIN_MENU, Sounds.MAIN_MENU_ITEM, Sounds.MESSAGE, Sounds.NO_APPLICATIONS, Sounds.NO_CONTENT, Sounds.NO_ITEMS_ABOVE, Sounds.NO_ITEMS_BELOW, Sounds.NO_LINES_ABOVE, Sounds.NO_LINES_BELOW, Sounds.OK, Sounds.PARAGRAPH, Sounds.PASTE, Sounds.PLAYING, Sounds.PROTECTED_RESOURCE, Sounds.REGION_POINT, Sounds.SEARCH, Sounds.SELECTED, Sounds.SHUTDOWN, Sounds.STARTUP, Sounds.TABLE_CELL, Sounds.TERM_BELL, Sounds.UNSELECTED};
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;

    SoundsList(ControlPanel controlPanel, ListArea.Params<Item> params) {
        super(params);
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        NullCheck.notNull(params, (String)"params");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.setListClickHandler(this);
    }

    @Override
    public boolean onListClick(ListArea area, int index, Item item) {
        NullCheck.notNull((Object)item, (String)"item");
        File file = Popups.existingFile(this.luwrain, this.luwrain.i18n().getStaticStr("CpSoundsListChangePopupName"));
        if (file == null || file.isDirectory()) {
            return true;
        }
        String soundsDirPath = this.luwrain.getFileProperty("luwrain.dir.sounds").getAbsolutePath();
        String path = file.getAbsolutePath();
        if (soundsDirPath.length() + 1 < path.length() && path.startsWith(soundsDirPath)) {
            String res = path.substring(soundsDirPath.length() + 1);
        } else {
            String res = path;
        }
        item.file = file;
        this.refresh();
        return true;
    }

    private boolean playSound() {
        Object obj = this.selected();
        if (obj == null || !(obj instanceof Item)) {
            return false;
        }
        Item item = (Item)obj;
        if (item.file == null || !item.file.exists() || item.file.isDirectory()) {
            return false;
        }
        if (this.luwrain.getPlayer() == null) {
            return false;
        }
        this.luwrain.getPlayer().play(new FixedPlaylist(Urls.toUrl(item.file).toString()), 0, 0L, Player.DEFAULT_FLAGS);
        return true;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        if (!event.isSpecial() && !event.isModified()) {
            switch (event.getChar()) {
                case ' ': {
                    return this.playSound();
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean saveSectionData() {
        return true;
    }

    private static Item[] loadItems(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        ArrayList res = new ArrayList();
        return res.toArray(new Item[res.size()]);
    }

    static SoundsList create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        Luwrain luwrain = controlPanel.getCoreInterface();
        ListArea.Params<Item> params = new ListArea.Params<Item>();
        params.context = new DefaultControlContext(luwrain);
        params.appearance = new ListUtils.DefaultAppearance(params.context, Suggestions.LIST_ITEM);
        params.name = luwrain.i18n().getStaticStr("CpSoundsList");
        params.model = new ListUtils.FixedModel<Item>(SoundsList.loadItems(luwrain));
        return new SoundsList(controlPanel, params);
    }

    private static String getI18nName(Sounds sound) {
        NullCheck.notNull((Object)((Object)sound), (String)"sound");
        StringBuilder b = new StringBuilder();
        String str = sound.toString();
        boolean wasLetter = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                b.append("" + (wasLetter ? Character.toLowerCase(c) : c));
                wasLetter = true;
                continue;
            }
            wasLetter = false;
        }
        return "CpSoundsList" + new String(b);
    }

    private static String getRegistryPath(Sounds sound) {
        NullCheck.notNull((Object)((Object)sound), (String)"sound");
        String str = sound.toString();
        return Registry.join("/org/luwrain/sounds/scheme", str.toLowerCase().replaceAll("_", "-"));
    }

    static final class Item {
        final Sounds sound;
        final String title;
        File file;

        Item(Sounds sound, String title, File file) {
            NullCheck.notNull((Object)((Object)sound), (String)"sound");
            NullCheck.notNull((Object)title, (String)"title");
            NullCheck.notNull((Object)file, (String)"file");
            this.sound = sound;
            this.title = title;
            this.file = file;
        }

        public String toString() {
            return this.title + ": " + this.file.getAbsolutePath();
        }
    }
}

