/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LineIterator
implements Iterator<String> {
    public static final String UTF_8 = "UTF_8";
    protected final BufferedReader r;
    protected String nextLine;

    public LineIterator(BufferedReader r) throws IOException {
        this.r = Objects.requireNonNull(r, "r can't be null");
        this.nextLine = r.readLine();
    }

    public LineIterator(Reader r) throws IOException {
        this(new BufferedReader(r));
    }

    public LineIterator(InputStream is, String charset) throws IOException {
        this(new InputStreamReader(is, charset));
    }

    public LineIterator(String str) throws IOException {
        this(new StringReader(str));
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public String next() {
        String currentLine = this.nextLine;
        try {
            this.nextLine = this.r.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return currentLine;
    }

    public List<String> toList() {
        ArrayList<String> a = new ArrayList<String>();
        while (this.hasNext()) {
            a.add(this.next());
        }
        return a;
    }

    public Stream<String> stream() {
        ArrayList<String> a = new ArrayList<String>();
        while (this.hasNext()) {
            a.add(this.next());
        }
        return a.stream();
    }

    public String join(String sep) {
        Objects.requireNonNull(sep, "sep can't be null");
        return this.stream().collect(Collectors.joining(sep));
    }

    public static List<String> toList(Path path, String charset) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            List<String> list = new LineIterator(is, charset).toList();
            return list;
        }
    }

    public static String join(Path path, String charset, String sep) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            String string = new LineIterator(is, charset).join(sep);
            return string;
        }
    }

    public static List<String> toList(File file, String charset) throws IOException {
        return LineIterator.toList(file.toPath(), charset);
    }

    public static String join(File file, String charset, String sep) throws IOException {
        return LineIterator.join(file.toPath(), charset, sep);
    }
}

