/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.luwrain.core.NullCheck;

public class MlTagStrip {
    private final StringBuilder builder = new StringBuilder();
    private final Document jsoupDoc;

    MlTagStrip(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.jsoupDoc = Jsoup.parse((String)text);
    }

    private void run() {
        this.onNode((Node)this.jsoupDoc.body());
    }

    private void onNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        List nodes = node.childNodes();
        if (nodes == null) {
            return;
        }
        for (Node n : nodes) {
            if (n instanceof TextNode) {
                TextNode textNode = (TextNode)n;
                String text = textNode.text();
                if (text == null) continue;
                this.builder.append(text);
                continue;
            }
            this.onNode(n);
        }
    }

    public static String run(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        MlTagStrip strip = new MlTagStrip(text);
        strip.run();
        return new String(strip.builder);
    }
}

